package cn.quantgroup.financial.service;

import cn.quantgroup.financial.BootStarter;
import cn.quantgroup.financial.constant.EncodingConfig;
import cn.quantgroup.financial.constant.HubeiCFCDataType;
import cn.quantgroup.financial.dao.IHuBeiCFCDao;
import cn.quantgroup.financial.model.huibeicfc.HuBeiHistory;
import cn.quantgroup.financial.scheduler.HuBeiReturnDiscScheduler;
import cn.quantgroup.financial.scheduler.HuBeiSendDiscScheduler;
import cn.quantgroup.financial.service.sys.IMailService;
import org.apache.commons.codec.binary.Base64;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.SpringApplicationConfiguration;
import org.springframework.core.env.Environment;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;

import javax.activation.DataSource;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by WuKong on 2017/1/19.
 */
@RunWith(SpringJUnit4ClassRunner.class)
@SpringApplicationConfiguration(classes = BootStarter.class)
@WebAppConfiguration
@ActiveProfiles("local")
public class HuBeiServiceTest {
    private static Logger logger = LoggerFactory.getLogger(HuBeiServiceTest.class);

    @Autowired
    Environment env;

    @Autowired
    IHuBeiService huBeiService;

    @Autowired
    HuBeiSendDiscScheduler huBeiSendDiscScheduler;

    @Autowired
    HuBeiReturnDiscScheduler huBeiReturnDiscScheduler;

    @Autowired
    IHuBeiCFCDao iHuBeiCFCDao;

    @Autowired
    private IMailService iMailService;

    private Object lock = new Object();


    /**
     * 扣款明细
     */
    @Test
    public void testReturnDebitDisc(){
        huBeiService.handleDiscData(HubeiCFCDataType.RETURN_BATCH_DEBIT,null,188L,new Integer(1).byteValue());
    }

    /**
     * 提前还款
     */
    @Test
    public void testReturnAdvanceRepayDisc(){
        huBeiService.handleDiscData(HubeiCFCDataType.RETURN_ADVANCE_REPAYMENT,"20170221_9009_T01.txt",10L,new Integer(1).byteValue());
    }

    /**
     * 代偿
     */
    public void testReturnCompensationDisc(){
        huBeiService.handleDiscData(HubeiCFCDataType.RETURN_BATCH_COMPENSATION,null,null,new Integer(1).byteValue());
    }

    @Test
    public void testGetHistory(){
        List<HuBeiHistory> huBeiHistoryList = iHuBeiCFCDao.getListByDocNameIdAndSeqNo(151L,new Integer(1).byteValue());
        HuBeiHistory history = huBeiHistoryList.get(0);
        System.out.println("ok");
    }

    @Test
    public void testGetSendDisc(){
        //20170119_9009_T01.txt
        try {
            huBeiService.handleDiscData(HubeiCFCDataType.SEND_DEBIT,null,null,new Integer(1).byteValue(),"20170224");
        } catch (Exception e) {
            logger.error(e.getMessage(),e);
        }
        synchronized (lock) {
            try {
                lock.wait();
            } catch (InterruptedException e) {
                logger.error(e.getMessage(), e);
            }
        }
    }

    @Test
    public void testCheckSendDisc(){
        //20170119_9009_T01.txt
        try {
            huBeiService.handleDiscData(HubeiCFCDataType.SEND_ADVANCE_REPAYMENT_CHECK,"20170221_9009_T01.txt",10L,new Integer(1).byteValue());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testScheduler(){
        huBeiSendDiscScheduler.dayScheduler();
    }


    @Test
    public void parse(){
        String line = "SFQxMDAwMDAyMDE2MTIxNzAwMjcwNDh85YiY5pWP5oyvfDIwfDQxMDgyNjE5OTIwNzA2MDUxNnxO\n" +
                "RnwyMDE3LTAzLTIwfDB8MjA0Ni44OHwwOXwyMDE2LTEyLTIyDUhUMTAwMDAwMjAxNjEyMTcwMDI3\n" +
                "MTk3fOaItOeni+e6onwyMHwyMTAxMDYxOTc2MDcxMDQ2NDV8TkZ8MjAxNy0wMy0xOXwwfDIwNDYu\n" +
                "ODh8MDl8MjAxNy0wMS0yMQ==";

        String result = (new String(Base64.decodeBase64(line), EncodingConfig.defaultCharset));
        System.out.println(result);
    }
    @Test
    public void testReturnScheduler(){
        huBeiReturnDiscScheduler.dayScheduler();
        synchronized (lock) {
            try {
                lock.wait();
            } catch (InterruptedException e) {
                logger.error(e.getMessage(), e);
            }
        }
    }

    @Test
    public void testSendMailNotice(){
        huBeiService.sendErrorMailNotice("test");
        synchronized (lock) {
            try {
                lock.wait();
            } catch (InterruptedException e) {
                logger.error(e.getMessage(), e);
            }
        }
    }

    @Test
    public  void testSendAttachmentMail(){
        DataSource dataSource = iMailService.getDataSource("lkdjflajdlfkajd;fajl","aaa.txt");
        ArrayList<DataSource> dataSourceList = new ArrayList<>();
        dataSourceList.add(dataSource);
        huBeiService.sendMailAttachment( HubeiCFCDataType.RETURN_ADVANCE_REPAYMENT,dataSourceList);
        synchronized (lock) {
            try {
                lock.wait();
            } catch (InterruptedException e) {
                logger.error(e.getMessage(), e);
            }
        }
    }
}
