package cn.quantgroup.financial.service;

import cn.quantgroup.financial.constant.HubeiCFCDataType;
import cn.quantgroup.financial.exception.RequestException;
import cn.quantgroup.financial.model.huibeicfc.HuBeiCFCRequest;
import cn.quantgroup.financial.model.huibeicfc.HuBeiCFCResponse;
import cn.quantgroup.financial.model.huibeicfc.HuBeiDocName;
import cn.quantgroup.financial.model.huibeicfc.HuBeiHistory;
import org.dom4j.DocumentException;
import org.springframework.scheduling.annotation.Async;
import org.xml.sax.SAXException;

import javax.activation.DataSource;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by WuKong on 2017/1/19.
 */
public interface IHuBeiService {

    HuBeiCFCResponse handleDiscData(HubeiCFCDataType hubeiCFCDataType,String docName,Long docId,Byte seqNo);

    /**
     * 时间当做参数接收 方便联调
     * @param hubeiCFCDataType
     * @param docName
     * @param docId
     * @param applyDt
     * @return
     */
    HuBeiCFCResponse handleDiscData(HubeiCFCDataType hubeiCFCDataType,String docName,Long docId,Byte seqNo,String applyDt);

    /**
     * 通过送盘文件 获取回盘数据
     * @param huBeiDocName
     * @return
     */
    List<HuBeiHistory> getReturnDisc(HuBeiDocName huBeiDocName);

    /**
     * 异常邮件通知
     * @param messageString
     */
    @Async
    void sendErrorMailNotice(String messageString);
    @Async
    void sendErrorMailNotice(List<HuBeiHistory> huBeiHistoryList, String noticeMessage);

    /**
     *  每日附件发送
     * @param hubeiCFCDataType
     * @param attachedBytes
     */
    void sendMailAttachment(HubeiCFCDataType hubeiCFCDataType, ArrayList<DataSource> attachedBytes);

    /**
     *
     * @param attachedBytes
     * @param toUserArray
     */
    void sendErrorMailAttachment(ArrayList<DataSource> attachedBytes, String[] toUserArray, String text, String subject);

    HuBeiDocName generateHuBeiDoc(HubeiCFCDataType hubeiCFCDataType,Byte seqNo);
}
