package cn.quantgroup.financial.dao;

import cn.quantgroup.financial.constant.HubeiCFCDataType;
import cn.quantgroup.financial.model.MailInfo;
import cn.quantgroup.financial.model.huibeicfc.HuBeiDocName;
import cn.quantgroup.financial.model.huibeicfc.HuBeiHistory;

import java.util.Date;
import java.util.List;

/**
 * Created by WuKong on 2017/1/19.
 */
public interface IHuBeiCFCDao {
    void saveHistoryAndDocName(HuBeiHistory history,HuBeiDocName docName);
    Long saveHistory(HuBeiHistory huBeiHistory);
    Long saveDocName(HuBeiDocName huBeiDocName);
    HuBeiDocName getDocNameById(Long docId);

    /**
     * 通过 happenTime时间范围查询
     * @param beforeTime
     * @param afterTime
     * @return
     */
    List<HuBeiHistory> getListByTimeScope(Date beforeTime, Date afterTime,HubeiCFCDataType hubeiCFCDataType);
    Integer updateDocName(HuBeiDocName huBeiDocName);
    List<HuBeiHistory> getListByDocNameId(Long docNameId);
    List<HuBeiHistory> getListByDocNameIdAndSeqNo(Long docNameId,Byte seqNo);
    HuBeiDocName getByDataTypeAndCreateTime(HubeiCFCDataType hubeiCFCDataType,Date dayDate);

    /**
     * 根据日期和类型查询同一天最近的文件
     * @param hubeiCFCDataType
     * @param queryDate
     * @return
     */
    HuBeiDocName getLastestDocByDataAndType(HubeiCFCDataType hubeiCFCDataType,Date queryDate);

    /**
     * 通过文件名和类型查找文件
     * @param docName
     * @param hubeiCFCDataType
     * @return
     */
    HuBeiDocName getByDocNameAndType(String docName,HubeiCFCDataType hubeiCFCDataType);

    Integer getMaxSeqNoByDocId(Long docId);
    List<MailInfo> getListByType(Byte type);

    /**
     * 通过合同号查询flow不为空的
     * @param contactNoList
     * @return
     */
    List<HuBeiHistory> getFlowByContractNoList(List<String> contactNoList);


}
