package cn.quantgroup.financial.aspect.exception;

import cn.quantgroup.financial.exception.ArgsInvaildException;
import cn.quantgroup.financial.exception.FieldInsufficientException;
import cn.quantgroup.financial.exception.NoAuthorityException;
import cn.quantgroup.financial.exception.ServerErrorException;
import cn.quantgroup.financial.json.JsonResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

/**
 * 统一拦截controller 异常
 * Created by WuKong on 2017/1/6.
 */
@ControllerAdvice
@RestController
public class ExceptionHandlingAdvice {

    private static Logger logger = LoggerFactory.getLogger(ExceptionHandlingAdvice.class);
    @ExceptionHandler(ArgsInvaildException.class)
    @ResponseStatus(HttpStatus.OK)
    public JsonResult argsInvaildException(ArgsInvaildException argsInvaildException){
        return JsonResult.ERROR_ARGS();
    }

    @ExceptionHandler(FieldInsufficientException.class)
    @ResponseStatus(HttpStatus.OK)
    public JsonResult fieldInsufficientException(FieldInsufficientException fieldInsufficientException){
        return JsonResult.ERROR_INSUFFICIENT(fieldInsufficientException.getMessage());
    }

    @ExceptionHandler(NoAuthorityException.class)
    @ResponseStatus(HttpStatus.UNAUTHORIZED)
    public JsonResult NoAuthorityException(){
        return JsonResult.NO_AUTHORITY();
    }

    @ExceptionHandler({ServerErrorException.class})
    @ResponseStatus(HttpStatus.OK)
    public JsonResult serverErrorException(){
        return JsonResult.ERROR_SERVER();
    }

    @ExceptionHandler({Exception.class})
    public JsonResult exception(Exception e){
        logger.error(e.getMessage(),e);
        return JsonResult.ERROR_SERVER();
    }
}
