package cn.quantgroup.financial.service.sys.impl;

import cn.quantgroup.financial.constant.SysConstant;
import cn.quantgroup.financial.service.sys.IScheduledJudgeService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/**
 * Created by WuKong on 2017/2/16.
 */
@Service
public class ScheduledJudgeServiceImpl implements IScheduledJudgeService {
    @Value("scheduled_trigger")
    private String scheduled_trigger_name;

    private static Logger logger = LoggerFactory.getLogger(ScheduledJudgeServiceImpl.class);


    /**
     * 判断是否开启定时任务
     * @return
     */
    @Override
    public Boolean isOpenScheduled(){
        try {
            String trigger = System.getenv(scheduled_trigger_name);
            if(StringUtils.isEmpty(trigger)){
                trigger = System.getProperty(scheduled_trigger_name);
            }
            logger.info("trigger name={}, value={}",scheduled_trigger_name,trigger);
            if(!StringUtils.isEmpty(trigger)&&"2".equals(trigger)){
                return false;
            }
        } catch (Exception e) {
            logger.error(e.getMessage());
        }
        return true;
    }
}
