package cn.quantgroup.financial.scheduler;

import cn.quantgroup.financial.constant.CompensationStatus;
import cn.quantgroup.financial.dao.IPaymentDao;
import cn.quantgroup.financial.service.sys.ICompensationDayService;
import cn.quantgroup.financial.service.sys.IScheduledJudgeService;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 *  定时执行 判断是否为代偿
 *  代偿日的处理数据
 * Created by wangbo on 2017/1/10.
 */
@Lazy(false)
@Component
public class CompensationDayScheduler {

    private static final Logger logger = LoggerFactory.getLogger(CompensationDayScheduler.class);
    @Autowired
    ICompensationDayService compensationDayService;

    @Autowired
    IPaymentDao iPaymentDao;

    @Autowired
    private IScheduledJudgeService scheduledJudgeService;
    /**
     * Seconds Minutes Hours DayofMonth Month DayofWeek
     */
    @Scheduled(cron = "1 0 0 * * ?")
    public void handleCompensationDay(){
        if(scheduledJudgeService.isOpenScheduled()){
            try {
                logger.info("handleCompensationDay start");
                Calendar calendar = Calendar.getInstance();
                logger.info("current day time ={}",calendar.getTime());
                if(compensationDayService.isCompensationDay()){
                    //代偿日做处理
                    //查询所有上一个代偿日到现在的数据 判断是否代偿
                    int year = calendar.get(Calendar.YEAR);
                    //1-12
                    int month = calendar.get(Calendar.MONTH)+1;
                    Date compensationDate = compensationDayService.getCompensationDay(year,month);
                    List<Long> idList = iPaymentDao.getIdListBeforeCompensationDate(compensationDate);
                    logger.info("compensationDate={}, idList={}", compensationDate,JSON.toJSONString(idList));
                    Integer row = iPaymentDao.updateBatchCompensationStatusById(idList, CompensationStatus.already_status.get());
                    logger.info("update row = {}",row);
                }else {
                    logger.info("it is not compensationDay");
                }
                logger.info("handleCompensationDay end");
            } catch (Exception e) {
                logger.error(e.getMessage(),e);
            }
        }
    }
}
