package cn.quantgroup.financial.util;

/**
 * Created by WuKong on 2017/2/13.
 */
public class StringFormat {
    /**
     * 格式化输出 字符串
     * [*]左对齐,右补空格

     *
     * @param str
     * @param min_length : 最小输出长度
     * @return
     */
    public static String formatLeftS(String str, int min_length) {
        String format = "%-" + (min_length < 1 ? 1 : min_length) + "s";
        return String.format(format, str);
    }

    /**
     * 格式化输出 整数
     * [*]右对齐,左补0

     *
     * @param num
     * @param min_length : 最小输出长度
     * @return
     */
    public static String format0Right(long num, int min_length) {
        String format = "%0" + (min_length < 1 ? 1 : min_length) + "d";
        return String.format(format, num);
    }

    /**
     * 格式化输出 浮点数
     * [*]右对齐,左补0

     *
     * @param d
     * @param min_length : 最小输出长度
     * @param precision : 小数点后保留位数
     * @return
     */
    public static String format0Right(double d, int min_length, int precision) {
        String format = "%0" + (min_length < 1 ? 1 : min_length) + "."
                + (precision < 0 ? 0 : precision) + "f";
        return String.format(format, d);
    }

    public static void main(String[] args) {
        System.out.println(format0Right(1L,2));
    }
}
