package cn.quantgroup.financial.util;

import cn.quantgroup.financial.exception.FieldInsufficientException;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by WuKong on 2017/1/6.
 */
public class CheckUtil {
    private static final Logger logger = LoggerFactory.getLogger(CheckUtil.class);

    /**
     * 判断是否要求的属性都有值
     * @param object
     * @param fieldNameList
     * @return
     */
    public static Boolean isFieldNotNull(Object object, List<String> fieldNameList){
        List<String> list = checkFieldValueNull(object,fieldNameList);
        if(CollectionUtils.isEmpty(list)){
            return Boolean.TRUE;
        }else {
            StringBuffer buffer = new StringBuffer("lacking essential field: ");
            for(String field: list){
                buffer.append(field).append("|");
            }
            logger.info(buffer.toString());
            return Boolean.FALSE;
        }
    }
    /**
     * 判断必要属性是否为null
     * @param object
     * @param fieldNameList
     * @throws FieldInsufficientException
     */
    public static void assertFieldNotNull(Object object, List<String> fieldNameList) throws FieldInsufficientException{
        List<String> list = checkFieldValueNull(object,fieldNameList);
        if(!CollectionUtils.isEmpty(list)){
            StringBuffer buffer = new StringBuffer("lacking essential field: ");
            for(String field: list){
                buffer.append(field).append("|");
            }
            String message = buffer.toString();
            logger.error(message);
            throw new FieldInsufficientException(message);
        }
    }

    /**
     * 检查必要字段 如果有缺失则返回缺失字段集合
     * @param
     * @return
     */
    public static List<String> checkFieldValueNull(Object object, List<String> fieldNameList){
        if(object==null){
            return null;
        }
        List<String> list = null;
        Class<?> tClass = object.getClass();
        for(String fieldName: fieldNameList){
            try {
                Field field = tClass.getDeclaredField(fieldName);
                field.setAccessible(true);
                if(field!=null&&field.get(object)==null){
                    //必要属性值不存在
                    if(list==null){
                        list = new ArrayList<>();
                    }
                    list.add(fieldName);
                }
            } catch (NoSuchFieldException e) {
                logger.error(e.getMessage(),e);
            } catch (IllegalAccessException e) {
                logger.error(e.getMessage(),e);
            }
        }

        return list;
    }
}
