package cn.quantgroup.financial.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class PaymentDetail implements Serializable{
    private Long id;
    //用户id
    private Long userId;
    //用户名
    private String userName;
    //手机号
    private String userPhoneNo;
    //证件号
    private String userIdNo;
    //证件类型，0 身份证号 其他待定
    private Byte userIdType;
    //借款id
    private Long loanHistoryId;
    //manifest id
    private Long loanManifestHistoryId;
    //商户合同号
    private String merchantContractNo;
    //资金方名
    private String fundingCorpName;
    //资金方id
    private Long fundingCorpId;
    //放款方名
    private String paymentCorpName;
    //放款方id
    private Long paymentCorpId;
    //总本金
    private BigDecimal totalPrincipal=BigDecimal.ZERO;
    //放款时间
    private Date loanPaidAt;
    //申请借款时间
    private Date loanCreateAt;
    //合同期数
    private Integer contractTotalTerm;

    private Date createTime;

    private Date updateTime;


    //-------------以下非db-----------------------------------------------------------------------------
    //还款计划详情
    private List<RepaymentPlanDetail> repaymentPlanDetailList;
    //要求不为空的字段名
    public static List<String> notNullField = new ArrayList<>(Arrays.asList("userId", "userName", "userPhoneNo","userIdNo","loanHistoryId","totalPrincipal","loanPaidAt","loanCreateAt","contractTotalTerm"));

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName == null ? null : userName.trim();
    }

    public String getUserPhoneNo() {
        return userPhoneNo;
    }

    public void setUserPhoneNo(String userPhoneNo) {
        this.userPhoneNo = userPhoneNo == null ? null : userPhoneNo.trim();
    }

    public String getUserIdNo() {
        return userIdNo;
    }

    public void setUserIdNo(String userIdNo) {
        this.userIdNo = userIdNo == null ? null : userIdNo.trim();
    }

    public Byte getUserIdType() {
        return userIdType;
    }

    public void setUserIdType(Byte userIdType) {
        this.userIdType = userIdType;
    }

    public Long getLoanHistoryId() {
        return loanHistoryId;
    }

    public void setLoanHistoryId(Long loanHistoryId) {
        this.loanHistoryId = loanHistoryId;
    }

    public Long getLoanManifestHistoryId() {
        return loanManifestHistoryId;
    }

    public void setLoanManifestHistoryId(Long loanManifestHistoryId) {
        this.loanManifestHistoryId = loanManifestHistoryId;
    }

    public String getMerchantContractNo() {
        return merchantContractNo;
    }

    public void setMerchantContractNo(String merchantContractNo) {
        this.merchantContractNo = merchantContractNo == null ? null : merchantContractNo.trim();
    }

    public String getFundingCorpName() {
        return fundingCorpName;
    }

    public void setFundingCorpName(String fundingCorpName) {
        this.fundingCorpName = fundingCorpName == null ? null : fundingCorpName.trim();
    }

    public Long getFundingCorpId() {
        return fundingCorpId;
    }

    public void setFundingCorpId(Long fundingCorpId) {
        this.fundingCorpId = fundingCorpId;
    }

    public String getPaymentCorpName() {
        return paymentCorpName;
    }

    public void setPaymentCorpName(String paymentCorpName) {
        this.paymentCorpName = paymentCorpName == null ? null : paymentCorpName.trim();
    }

    public Long getPaymentCorpId() {
        return paymentCorpId;
    }

    public void setPaymentCorpId(Long paymentCorpId) {
        this.paymentCorpId = paymentCorpId;
    }

    public BigDecimal getTotalPrincipal() {
        return totalPrincipal;
    }

    public void setTotalPrincipal(BigDecimal totalPrincipal) {
        this.totalPrincipal = totalPrincipal;
    }

    public Date getLoanPaidAt() {
        return loanPaidAt;
    }

    public void setLoanPaidAt(Date loanPaidAt) {
        this.loanPaidAt = loanPaidAt;
    }

    public Date getLoanCreateAt() {
        return loanCreateAt;
    }

    public void setLoanCreateAt(Date loanCreateAt) {
        this.loanCreateAt = loanCreateAt;
    }

    public Integer getContractTotalTerm() {
        return contractTotalTerm;
    }

    public void setContractTotalTerm(Integer contractTotalTerm) {
        this.contractTotalTerm = contractTotalTerm;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public List<RepaymentPlanDetail> getRepaymentPlanDetailList() {
        return repaymentPlanDetailList;
    }

    public void setRepaymentPlanDetailList(List<RepaymentPlanDetail> repaymentPlanDetailList) {
        this.repaymentPlanDetailList = repaymentPlanDetailList;
    }

    @Override
    public String toString() {
        return "PaymentDetail{" +
                "id=" + id +
                ", userId=" + userId +
                ", userName='" + userName + '\'' +
                ", userPhoneNo='" + userPhoneNo + '\'' +
                ", userIdNo='" + userIdNo + '\'' +
                ", userIdType=" + userIdType +
                ", loanHistoryId=" + loanHistoryId +
                ", loanManifestHistoryId=" + loanManifestHistoryId +
                ", merchantContractNo='" + merchantContractNo + '\'' +
                ", fundingCorpName='" + fundingCorpName + '\'' +
                ", fundingCorpId=" + fundingCorpId +
                ", paymentCorpName='" + paymentCorpName + '\'' +
                ", paymentCorpId=" + paymentCorpId +
                ", totalPrincipal=" + totalPrincipal +
                ", loanPaidAt=" + loanPaidAt +
                ", loanCreateAt=" + loanCreateAt +
                ", contractTotalTerm=" + contractTotalTerm +
                ", createTime=" + createTime +
                ", updateTime=" + updateTime +
                '}';
    }
}