package cn.quantgroup.financial.dao.impl;

import cn.quantgroup.financial.aspect.data.DataSourceConfig;
import cn.quantgroup.financial.constant.DataBaseType;
import cn.quantgroup.financial.constant.OfflineRepayStatus;
import cn.quantgroup.financial.dao.IRepayOfflineRecordDao;
import cn.quantgroup.financial.mapper.RepayOfflineRecordMapper;
import cn.quantgroup.financial.model.RepayOfflineRecord;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Created by WuKong on 2017/3/8.
 */
@DataSourceConfig(DataBaseType.System_DB)
@Service
public class RepayOfflineRecordDaoImpl implements IRepayOfflineRecordDao {

    @Autowired
    private RepayOfflineRecordMapper repayOfflineRecordMapper;

    @Override
    public List<RepayOfflineRecord> getByNotInLoanListAndRepayStatusAndUpdateAt(List<Long> loanList,OfflineRepayStatus offlineRepayStatus, Date gtTime, Date ltTime){
        if(offlineRepayStatus==null||gtTime==null||ltTime==null){
            return new ArrayList<RepayOfflineRecord>();
        }
        return repayOfflineRecordMapper.getByRepayStatusAndUpdateAt(loanList,offlineRepayStatus.get(),gtTime,ltTime);
    }

    public List<RepayOfflineRecord> getByReapyStatusAndLoanList(OfflineRepayStatus offlineRepayStatus,List<Long> loanList){
        if(offlineRepayStatus==null|| CollectionUtils.isEmpty(loanList)){
            return new ArrayList<RepayOfflineRecord>();
        }
        return repayOfflineRecordMapper.getByReapyStatusAndLoanList(offlineRepayStatus.get(),loanList);
    }
}
