package cn.quantgroup.financial.constant;

import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by WuKong on 2017/1/18.
 */
public class HubeiCFCField {
    public static final String root = "root";
    public static final String ec = "ec";
    public static final String em = "em";
    public static final String Resp = "Resp";
    public static final String head = "head";
    public static final String channel = "channel";
    public static final String currentBusinessCode = "currentBusinessCode";
    public static final String flowNo = "flowNo";
    public static final String reqTime = "reqTime";
    public static final String sign = "sign";
    public static final String signFlag = "signFlag";
    public static final String reqdata = "reqdata";
    public static final String xmlString = "xmlString";
    public static final String applCde = "applCde";
    public static final String cstno = "cstno";
    public static final String typGrp= "typGrp";
    /**
     * 当前机器时间
     * 格式：yyMMdd
     */
    public static final String applyDt = "applyDt";
    /**
     * 文件种类
     * 回盘：
     * 0：扣款文件
     * 1：代偿明细文件
     * 2：提前还款文件
     * 送盘：
     * 0：扣款送盘文件
     * 1：提前还款校验结果文件
     */
    public static final String flag = "flag";

    /**
     * 资料文件名称
     * 批扣文件：yyyymmdd_9009_P01.txt
     * 代偿明细：
     * yyyymmdd_9009_ D01.txt
     * 提前还款文件：
     * yyyymmdd_9009_ T01.txt
     * 9009 ：渠道标识；
     * 01：是指同类文件的批次；
     * P:批扣文件；
     * D:代偿文件；
     * T：提前还款文件
     */
    public static final String docName = "docName";

    /**
     * 影像资料文件流
     * 流：Base64编码过的字节数组字符串
     */
    public static final String picUploadFile = "picUploadFile";

    /**
     * 送盘文件业务码
     */
    public static final String SendDiscBusinessCode = "CF004053";

    /**
     * 回盘文件业务码
     */
    public static final String ReturnDiscBusinessCode = "CF004052";

    public static final Map<HubeiCFCDataType,String> businessMap = new HashMap<HubeiCFCDataType,String>(){
        {
            put(HubeiCFCDataType.RETURN_BATCH_DEBIT,ReturnDiscBusinessCode);
            put(HubeiCFCDataType.RETURN_BATCH_COMPENSATION,ReturnDiscBusinessCode);
            put(HubeiCFCDataType.RETURN_ADVANCE_REPAYMENT,ReturnDiscBusinessCode);
            put(HubeiCFCDataType.SEND_DEBIT,SendDiscBusinessCode);
            put(HubeiCFCDataType.SEND_ADVANCE_REPAYMENT_CHECK,SendDiscBusinessCode);
        }
    };

    public static final Map<Byte,HubeiCFCDataType> HubeiTypeMap = new HashMap<Byte,HubeiCFCDataType>(){
        {
            put(HubeiCFCDataType.RETURN_BATCH_DEBIT.get(),HubeiCFCDataType.RETURN_BATCH_DEBIT);
            put(HubeiCFCDataType.RETURN_BATCH_COMPENSATION.get(),HubeiCFCDataType.RETURN_BATCH_COMPENSATION);
            put(HubeiCFCDataType.RETURN_ADVANCE_REPAYMENT.get(),HubeiCFCDataType.RETURN_ADVANCE_REPAYMENT);
            put(HubeiCFCDataType.SEND_DEBIT.get(),HubeiCFCDataType.SEND_DEBIT);
            put(HubeiCFCDataType.SEND_ADVANCE_REPAYMENT_CHECK.get(),HubeiCFCDataType.SEND_ADVANCE_REPAYMENT_CHECK);
        }
    };

    public static final String chanel_9009 = "9009";

    /**
     * ec状态 成功码
     */
    public static final String EC_SUCCESS_CODE = "0";
    /**
     * 文件不存在
     */
    public static final String EC_FILENOTEXIST = "CFLN4053";

    /**
     * 交易码
     */
    public static final String tradeCodeSuccess = "0000";
    public static final String tradeCodeNoTrade = "0001";
    public static final String tradeCodeWrongPrice = "2222";
    /**
     * 交易结果
     */
    public static final String tradeMsgSuccess = "交易成功";
    public static final String tradeMsgNoTrade = "未还款";
    public static final String tradeMsgWrongPrice = "金额不正确";

    public static final Map<String,String> codeMappingMsg = new HashMap<String,String>(){
        {
            put(tradeCodeSuccess,tradeMsgSuccess);
            put(tradeCodeNoTrade,tradeMsgNoTrade);
            put(tradeCodeWrongPrice,tradeMsgWrongPrice);
        }
    };

    /**
     * 还款模式
     */
    public static final String repayType = "NF";

    /**
     * 还款渠道
     */
    public static final String repayChannel = "09";

    /**
     * 回盘文件后缀名
     */
    public static final Map<HubeiCFCDataType,String> fileAlias = new HashMap<HubeiCFCDataType,String>(){
        {
           put(HubeiCFCDataType.RETURN_BATCH_DEBIT,"P");
            put(HubeiCFCDataType.RETURN_BATCH_COMPENSATION,"D");
            put(HubeiCFCDataType.RETURN_ADVANCE_REPAYMENT,"T");
        }};

    /**
     * ec状态码
     */
    public static class EcCode {
        public static final String defaultCode = "-1";
    }

    public static Integer thirtyMintes = 30;
    public static Integer tenMinutes = 10;
}
