package cn.quantgroup.financial.handler.hubei.impl;

import cn.quantgroup.financial.constant.HubeiCFCDataType;
import cn.quantgroup.financial.constant.SysConstant;
import cn.quantgroup.financial.handler.hubei.HubeiContentHandler;
import cn.quantgroup.financial.model.huibeicfc.HuBeiHistory;
import cn.quantgroup.financial.model.huibeicfc.HuBeiJsonBean;
import cn.quantgroup.financial.util.HubeiCFCUtil;
import cn.quantgroup.financial.util.NumberUtils;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

/**
 * 扣款送盘
 * Created by WuKong on 2017/1/19.
 */
@Service
public class SendDebitHandler implements HubeiContentHandler {

    @Override
    public HuBeiHistory parse(String line) {
        String[] args =  line.split(SysConstant.verticalRegx);
        HuBeiHistory history = new HuBeiHistory();
        history.setFlowNo(args[0]);
        history.setContactNo(args[1]);
        history.setUserName(args[2]);
        history.setUserIdType(HubeiCFCUtil.getIDType(args[3]));
        history.setUserIdNo(args[4]);
        history.setDataType(getType().get());

        HuBeiJsonBean jsonBean = new HuBeiJsonBean();
        HubeiCFCUtil.copy(history,jsonBean);
        jsonBean.setRepayAmount(new BigDecimal(args[5]));
        jsonBean.setTradeCode(args[6]);
        if(args.length==13){
            jsonBean.setShouldRepayDate(args[7]);
            jsonBean.setShouldRepayPrincipal(new BigDecimal(args[8]));
            jsonBean.setShouldRepayInterest(new BigDecimal(args[9]));
            jsonBean.setShouldRepayOverdueInterest(new BigDecimal(args[10]));
            jsonBean.setShouldRepayCompoundInterest(new BigDecimal(args[11]));
            jsonBean.setShouldRepayTotalFee(new BigDecimal(args[12]));
        }


        history.setData(jsonBean);
        return history;
    }

    @Override
    public HubeiCFCDataType getType() {
        return HubeiCFCDataType.SEND_DEBIT;
    }

    @Override
    public String builder(HuBeiHistory huBeiHistory) {
        return new StringBuilder(huBeiHistory.getFlowNo())
                .append(SysConstant.vertical).append(huBeiHistory.getContactNo())
                .append(SysConstant.vertical).append(huBeiHistory.getUserName())
                .append(SysConstant.vertical).append(HubeiCFCUtil.getHuBeiType(huBeiHistory.getUserIdType()))
                .append(SysConstant.vertical).append(huBeiHistory.getUserIdNo())
                .append(SysConstant.vertical).append(NumberUtils.getNotNullToString(huBeiHistory.getData().getRepayAmount()))
                .append(SysConstant.vertical).append(huBeiHistory.getData().getTradeCode())
                .append(SysConstant.vertical).append(huBeiHistory.getData().getShouldRepayDate())
                .append(SysConstant.vertical).append(NumberUtils.getNotNullToString(huBeiHistory.getData().getShouldRepayPrincipal()))
                .append(SysConstant.vertical).append(NumberUtils.getNotNullToString(huBeiHistory.getData().getShouldRepayInterest()))
                .append(SysConstant.vertical).append(NumberUtils.getNotNullToString(huBeiHistory.getData().getShouldRepayOverdueInterest()))
                .append(SysConstant.vertical).append(NumberUtils.getNotNullToString(huBeiHistory.getData().getShouldRepayCompoundInterest()))
                .append(SysConstant.vertical).append(NumberUtils.getNotNullToString(huBeiHistory.getData().getShouldRepayTotalFee())).toString();
    }
}
