package cn.quantgroup.financial.controller;

import cn.quantgroup.financial.json.JsonResult;
import cn.quantgroup.financial.model.MailInfo;
import cn.quantgroup.financial.model.RepaymentPlanStatus;
import cn.quantgroup.financial.service.IApiCommonService;
import cn.quantgroup.financial.service.sys.IMailService;
import cn.quantgroup.financial.util.ResultCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * Created by WuKong on 2017/2/19.
 */
@Controller
@RequestMapping("/system")
public class SystemToolsController {

    private static Logger logger = LoggerFactory.getLogger(SystemToolsController.class);

    @Autowired
    private IMailService mailService;

    @Autowired
    private IApiCommonService apiCommonService;

    @RequestMapping(value = "/mailinfo/save", method = RequestMethod.POST)
    public  @ResponseBody JsonResult saveMailInfo(@RequestBody MailInfo mailInfo){
        Long mailId = null;
        if(mailInfo !=null){
            mailId = mailService.saveMailInfo(mailInfo);
        }
        return JsonResult.SUCCESS(mailId);
    }

    @RequestMapping(value = "/mailinfo/delete", method = {RequestMethod.GET,RequestMethod.POST,RequestMethod.DELETE})
    public  @ResponseBody JsonResult paymentNotify(@RequestParam("mailId") Long mailId){
        Integer row = null;
        if(mailId!=null){
            row = mailService.deleteMailInfo(mailId);
        }
        return JsonResult.SUCCESS(row);
    }

    @RequestMapping(value = "/payment/update", method = {RequestMethod.GET,RequestMethod.POST,RequestMethod.DELETE})
    public  @ResponseBody JsonResult updateContractNo(@RequestParam("contractNo") String contractNo,@RequestParam("loanHistoryId") Long loanHistoryId){
        Integer row = null;
//        row = apiCommonService.updateMerchantContractNo(contractNo,loanHistoryId);
        return JsonResult.SUCCESS(row);
    }

    /**
     * 检查系统服务是否可用
     * @return
     */
    @RequestMapping(value = "/checkFinancialSysValid",method = {RequestMethod.POST,RequestMethod.GET})
    @ResponseBody
    public JsonResult checkFinancialSysValid(){
        try {
            List<RepaymentPlanStatus> repaymentPlanStatusList = apiCommonService.getRepaymentPlanStatus(32618252L,6609158L);
        } catch (Exception e) {
            logger.error(e.getMessage(),e);
            return JsonResult.builder(ResultCode.UNKNOWN_ERROR,"system api 数据库连接异常");
        }
        return JsonResult.SUCCESS("system api  is OK");
    }
}
