package cn.quantgroup.financial.json;

import cn.quantgroup.financial.util.ResultCode;

import java.io.Serializable;

/**
 * Created by WuKong on 2017/1/5.
 */
public class JsonResult implements Serializable {
    private int code;
    private String msg;
    private Object data;


    private JsonResult(int code ,String msg,Object data){
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public static JsonResult SUCCESS(Object data){
        return new JsonResult(ResultCode.OK.getCode(),ResultCode.OK.getMsg(),data);
    }

    public static JsonResult SUCCESS(){
        return new JsonResult(ResultCode.OK.getCode(),ResultCode.OK.getMsg(),null);
    }

    public static JsonResult builder(ResultCode resultCode,Object data){
        return new JsonResult(resultCode.getCode(),resultCode.getMsg(),data);
    }

    public static JsonResult builder(int code ,String msg,Object data){
        return new JsonResult(code,msg,data);
    }
    /**
     * 参数错误
     * @return
     */
    public static JsonResult ERROR_ARGS(){
        return new JsonResult(ResultCode.ARGUMENT_ERROR.getCode(),ResultCode.ARGUMENT_ERROR.getMsg(),null);
    }


    public static JsonResult NO_AUTHORITY(){
        return new JsonResult(ResultCode.NO_AUTHORITY.getCode(),ResultCode.NO_AUTHORITY.getMsg(),null);
    }

    public static JsonResult ERROR_INSUFFICIENT(String message){
        return new JsonResult(ResultCode.FIELD_INSUFFICIENT.getCode(),message,null);
    }

    public static JsonResult ERROR_INSUFFICIENT(){
        return new JsonResult(ResultCode.FIELD_INSUFFICIENT.getCode(),ResultCode.FIELD_INSUFFICIENT.getMsg(),null);
    }
    /**
     * 内部错误
     * @return
     */
    public static JsonResult ERROR_SERVER(){
        return new JsonResult(ResultCode.FAILURE.getCode(),ResultCode.FAILURE.getMsg(),null);
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public Object getData() {
        return data;
    }

    public void setData(Object data) {
        this.data = data;
    }
}
