package cn.quantgroup.financial.aspect.data;

import cn.quantgroup.financial.constant.DataBaseType;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Created by WuKong on 2017/1/6.
 */
public class DataSourceContextHolder {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceContextHolder.class);

    private static final ThreadLocal<String> dataSourceName = new ThreadLocal<String>();

    public static void setDbName(String name) {
        dataSourceName.set(name);
    }

    public static boolean isSystemDB() {
        if(!StringUtils.isEmpty(dataSourceName.get())&& dataSourceName.get().equals(DataBaseType.System_DB.get())){
            return true;
        }else {
            return false;
        }

    }
}
