package cn.quantgroup.financial.util;


/**
 * 
 * @author dave
 *
 */
public enum ResultCode {

    OK(200, "OK", 1),
    FAILURE(500, "操作失败", 1),
    UNKNOWN_ERROR(501, "未知错误", 1),
    ARGUMENT_ERROR(400, "参数错误", 1),
    MISSING_ARGUMENT(401, "缺少参数", 1),
    ARGUMENT_TYPE_ERROR(402, "参数类型错误", 1),
    NO_AUTHORITY(403, "无权操作", 1),
    METHOD_TYPE_ERROR(406, "请求方法错误", 1),
    METHOD_NOT_FOUND(407, "调用接口不存在", 1),
    FIELD_INSUFFICIENT(408, "必要属性不足", 1),
    UNKNOW_RESULT(409, "查询不到结果集", 1),
    ;


    private int code;

    private String msg;

    private ResultCode(int code, String msg, int level){
        this.code = code;
        this.msg = msg;
    }

    public int getCode(){
        return code;
    }

    public String getMsg(){
        return msg;
    }
}
