package cn.quantgroup.financial.handler.mybatis;

import cn.quantgroup.financial.model.huibeicfc.HuBeiJsonBean;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.apache.ibatis.type.TypeHandler;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * http://www.cnblogs.com/waterystone/p/5547254.html
 * mapper里json型字段到类的映射。
 * 用法一:
 * 入库：#{jsonDataField, typeHandler=com.adu.spring_test.mybatis.typehandler.JsonTypeHandler}
 * 出库：
 * <resultMap>
 * <result property="jsonDataField" column="json_data_field" javaType="com.xxx.MyClass" typeHandler="com.adu.spring_test.mybatis.typehandler.JsonTypeHandler"/>
 * </resultMap>
 *
 * 用法二：
 * 1）在mybatis-config.xml中指定handler:
 *      <typeHandlers>
 *              <typeHandler handler="com.adu.spring_test.mybatis.typehandler.JsonTypeHandler" javaType="com.xxx.MyClass"/>
 *      </typeHandlers>
 * 2)在MyClassMapper.xml里直接select/update/insert。
 *
 *
 * @author yunjie.du
 * @date 2016/5/31 19:33
 */
/**
 * Created by WuKong on 2017/1/19.
 */
@MappedTypes(HuBeiJsonBean.class)
@MappedJdbcTypes(JdbcType.VARCHAR)
public class JsonMybatisHandler implements TypeHandler<HuBeiJsonBean> {

    @Override
    public void setParameter(PreparedStatement preparedStatement, int i, HuBeiJsonBean huBeiJsonBean, JdbcType jdbcType) throws SQLException {
        preparedStatement.setString(i,JSON.toJSONString(huBeiJsonBean));
    }

    @Override
    public HuBeiJsonBean getResult(ResultSet resultSet, String s) throws SQLException {
        return JSONObject.parseObject(resultSet.getString(s), HuBeiJsonBean.class);
    }

    @Override
    public HuBeiJsonBean getResult(ResultSet resultSet, int i) throws SQLException {
        return JSONObject.parseObject(resultSet.getString(i), HuBeiJsonBean.class);
    }

    @Override
    public HuBeiJsonBean getResult(CallableStatement callableStatement, int i) throws SQLException {
        return JSONObject.parseObject(callableStatement.getString(i),HuBeiJsonBean.class);
    }
}
