package cn.quantgroup.financial.dao.impl;

import cn.quantgroup.financial.aspect.data.DataSourceConfig;
import cn.quantgroup.financial.constant.DataBaseType;
import cn.quantgroup.financial.dao.IRepayRecordDao;
import cn.quantgroup.financial.mapper.RepayRecordMapper;
import cn.quantgroup.financial.mapper.RepayXyqbDetailMapper;
import cn.quantgroup.financial.model.RepayXyqbDetail;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Created by WuKong on 2017/1/23.
 */
@DataSourceConfig(DataBaseType.System_DB)
@Service
public class RepayRecordDaoImpl implements IRepayRecordDao {

    @Autowired
    private RepayRecordMapper repayRecordMapper;

    @Autowired
    private RepayXyqbDetailMapper repayXyqbDetailMapper;

    private static final Logger logger = LoggerFactory.getLogger(RepayRecordDaoImpl.class);

    /**
     * 通过还款时间间隔以及资金方id查询 还款信息
     * @param fundingCorpId
     * @param beforeTime
     * @param afterTime
     * @return
     */
    @Override
    public List<RepayXyqbDetail> getRepayXyqbDetailList(Long fundingCorpId,Date beforeTime,Date afterTime){
        return repayXyqbDetailMapper.getRepayXyqbDetailList(fundingCorpId,beforeTime,afterTime);
    }

    @Override
    public List<RepayXyqbDetail> getListByLoanHistroyIds(Long fundingCorpId,List<Long> loanHistoryIdList){
        if(fundingCorpId==null||CollectionUtils.isEmpty(loanHistoryIdList)){
            return new ArrayList<RepayXyqbDetail>();
        }
        return repayXyqbDetailMapper.getListByLoanHistroyIds(fundingCorpId,loanHistoryIdList);
    }

    /**
     * 排除loanId list之后 时间段内的某一资金方 还款记录
     * order by loan_application_history_id curr_term_no ASC
     * @param fundingCorpId
     * @param loanHistoryIdList
     * @param gtDate
     * @param ltDate
     * @return
     */
    @Override
    public List<RepayXyqbDetail> getListNotLoanIdBetweenDate(Long fundingCorpId,List<Long> loanHistoryIdList,Date gtDate,Date ltDate){
        if(loanHistoryIdList==null){
            loanHistoryIdList = new ArrayList<Long>();
        }
        return repayXyqbDetailMapper.getListNotLoanIdBetweenDate(fundingCorpId,loanHistoryIdList,gtDate,ltDate);
    }
}
