package cn.quantgroup.financial.dao.impl;

import cn.quantgroup.financial.constant.HubeiCFCDataType;
import cn.quantgroup.financial.dao.IHuBeiCFCDao;
import cn.quantgroup.financial.mapper.HuBeiDocNameMapper;
import cn.quantgroup.financial.mapper.HuBeiHistoryMapper;
import cn.quantgroup.financial.mapper.MailInfoMapper;
import cn.quantgroup.financial.mapper.PaymentDetailMapper;
import cn.quantgroup.financial.model.MailInfo;
import cn.quantgroup.financial.model.PaymentDetail;
import cn.quantgroup.financial.model.huibeicfc.HuBeiDocName;
import cn.quantgroup.financial.model.huibeicfc.HuBeiHistory;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Created by WuKong on 2017/1/19.
 */
@Service
public class HuBeiCFCDaoImpl implements IHuBeiCFCDao {
    private static final Logger logger = LoggerFactory.getLogger(HuBeiCFCDaoImpl.class);

    @Autowired
    HuBeiDocNameMapper huBeiDocNameMapper;

    @Autowired
    HuBeiHistoryMapper huBeiHistoryMapper;

    @Autowired
    PaymentDetailMapper paymentDetailMapper;

    @Autowired
    MailInfoMapper mailInfoMapper;

    @Transactional(rollbackFor=Exception.class)
    @Override
    public void saveHistoryAndDocName(HuBeiHistory history,HuBeiDocName docName){
        saveDocName(docName);
        history.setDocNameId(docName.getId());
        PaymentDetail paymentDetail = paymentDetailMapper.getByUserIdNo(history.getUserIdNo());
        if(paymentDetail!=null){
            history.setUserId(paymentDetail.getUserId());
        }else {
            logger.info("can`t query payment info, userIdNo={}",history.getUserIdNo());
        }
        saveHistory(history);
    }


    @Override
    public HuBeiDocName getByDocNameAndType(String docName,HubeiCFCDataType hubeiCFCDataType){
        return huBeiDocNameMapper.getByDocNameAndType(docName,hubeiCFCDataType.get());
    }
    @Override
    public List<HuBeiHistory> getListByTimeScope(Date beforeTime, Date afterTime, HubeiCFCDataType hubeiCFCDataType){
        List<HuBeiHistory> huBeiHistoryList = huBeiHistoryMapper.getListByTimeScope(beforeTime,afterTime,hubeiCFCDataType.get());
        return huBeiHistoryList;
    }

    @Override
    public List<HuBeiHistory> getListByDocNameId(Long docNameId){
        if(docNameId==null){
            return new ArrayList<HuBeiHistory>();
        }
        return huBeiHistoryMapper.getListByDocNameId(docNameId);
    }

    @Override
    public List<HuBeiHistory> getListByDocNameIdAndSeqNo(Long docNameId,Byte seqNo){
        if(docNameId==null||seqNo==null){
            return new ArrayList<HuBeiHistory>();
        }
        return huBeiHistoryMapper.getListByDocNameIdAndSeqNo(docNameId,seqNo);
    }
    @Override
    public HuBeiDocName getByDataTypeAndCreateTime(HubeiCFCDataType hubeiCFCDataType,Date dayDate){
        return huBeiDocNameMapper.getByDataTypeAndCreateTime(dayDate,hubeiCFCDataType.get());
    }

    /**
     * 根据日期和类型查询同一天最近的文件
     * @param hubeiCFCDataType
     * @param queryDate
     * @return
     */
    @Override
    public HuBeiDocName getLastestDocByDataAndType(HubeiCFCDataType hubeiCFCDataType,Date queryDate){
        return huBeiDocNameMapper.getLastestDocByDataAndType(queryDate,hubeiCFCDataType.get());
    }

    @Override
    @Transactional(rollbackFor=Exception.class)
    public Long saveHistory(HuBeiHistory huBeiHistory){
        huBeiHistory.setCreateTime(new Date());
        huBeiHistory.setUpdateTime(new Date());
        int row = huBeiHistoryMapper.insert(huBeiHistory);
        return huBeiHistory.getId();
    }

    @Override
    public Integer getMaxSeqNoByDocId(Long docId){
        if(docId==null){
            return null;
        }
        return huBeiHistoryMapper.getMaxSeqNoByDocId(docId);
    }

    @Transactional(rollbackFor=Exception.class)
    @Override
    public Long saveDocName(HuBeiDocName huBeiDocName){
        huBeiDocName.setCreateTime(new Date());
        huBeiDocName.setUpdateTime(new Date());
        long row = huBeiDocNameMapper.insert(huBeiDocName);
        return huBeiDocName.getId();
    }

    @Override
    public HuBeiDocName getDocNameById(Long docId){
        return huBeiDocNameMapper.selectByPrimaryKey(docId);
    }

    @Override
    public Integer updateDocName(HuBeiDocName huBeiDocName){
        return huBeiDocNameMapper.updateByPrimaryKeySelective(huBeiDocName);
    }

    @Override
    public List<MailInfo> getListByType(Byte type){
        return mailInfoMapper.getByType(type);
    }

    @Override
    public List<HuBeiHistory> getFlowByContractNoList(List<String> contactNoList){
        if(CollectionUtils.isEmpty(contactNoList)){
            return new ArrayList<HuBeiHistory>();
        }
        return huBeiHistoryMapper.getFlowByContractNoList(contactNoList);
    }

}
