package cn.quantgroup.financial.dao;

import cn.quantgroup.financial.exception.ArgsInvaildException;
import cn.quantgroup.financial.model.PaymentDetail;
import cn.quantgroup.financial.model.RepaymentPlanDetail;
import cn.quantgroup.financial.model.RepaymentPlanStatus;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;

/**
 * Created by WuKong on 2017/1/6.
 */
public interface IPaymentDao {

    /**
     * 查询代偿状态
     * @param loanHistoryId 借款id
     * @param repaymentPlanId 还款计划id
     * @return
     * @throws ArgsInvaildException
     */
    List<RepaymentPlanStatus> getRepaymentPlanStatus(Long loanHistoryId, Long repaymentPlanId) throws ArgsInvaildException;

    /**
     *
     * 保存放款信息 和 还款计划信息
     * @param paymentDetail 数据装填好再传入
     * @return
     */
    Integer savePaymentDetailAndRepaymentPlan(PaymentDetail paymentDetail);



    /**
     * 通过
     * @param loanHistoryIdList
     * @return
     */
    List<RepaymentPlanDetail> getRepaymentPlanListByLoanIds(List<Long> loanHistoryIdList);

    List<RepaymentPlanDetail> getListByLoanIdsAndCompensationStatus(List<Long> loanHistoryIdList,Byte compensationStatus);


    List<RepaymentPlanDetail> getListByCompensationDateAndLoanIds(List<Long> loanHistoryIdList,Date compensationDate);
    /**
     * 通过代偿日 查询id list
     * @param compensationDate
     * @return
     */
    List<Long> getIdListByCompensationDate(Date compensationDate);

    /**
     * 通过合同号返回paymentDetail
     * @param contractNoList
     * @return
     */
    List<PaymentDetail> getListByMerchantContractNo(List<String> contractNoList);
    PaymentDetail getByLoanId(Long loanHistoryId);

    /**
     *
     * @param loanHistoryId
     * @param term
     * @return
     */
    RepaymentPlanDetail getByLoanIdAndTerm(Long loanHistoryId,Integer term);
    /**
     * 批量更新代偿状态
     * @param idList
     * @param compensationStatus
     * @return
     */
    Integer updateBatchCompensationStatusById(List<Long> idList,Byte compensationStatus);

    List<Long> getIdListBeforeCompensationDate(Date compensationDate);

    Integer updateBatchCompensationStatusBeforeDate(Date beforeDate,Byte compensationStatus);

    Integer updateMerchantContractNo(String contractNo,Long loanHistoryId);
}
