package cn.quantgroup.financial.aspect.data;

import cn.quantgroup.financial.constant.DataBaseType;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.MethodBeforeAdvice;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

/**
 * Created by WuKong on 2017/1/6.
 */
public class DataSourceBeforeAdvice implements MethodBeforeAdvice, Ordered {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceBeforeAdvice.class);

    @Override
    public void before(Method method, Object[] args, Object target) throws Throwable {
        String name = "";
        if (logger.isInfoEnabled()) {
            name = target.getClass().getName() + "#" + method.getName();
        }

        //计算路由DB Group
        Method realMethod = target.getClass().getMethod(method.getName(), method.getParameterTypes());
        //处理数据源
        Annotation trsAnnotation = AnnotationUtils.getAnnotation(realMethod, DataSourceConfig.class);
        if(trsAnnotation==null){
            trsAnnotation = AnnotationUtils.getAnnotation(target.getClass(), DataSourceConfig.class);
        }
        if (trsAnnotation != null) {
            logger.debug("set datasource true ! {} !", name);
            DataBaseType dataBaseType = (DataBaseType)AnnotationUtils.getValue(trsAnnotation);
            DataSourceContextHolder.setDbName(dataBaseType.get());
        } else {
            logger.debug("set datasource null ! {} !", name);
            DataSourceContextHolder.setDbName(null);
        }
    }

    public Object doAround(ProceedingJoinPoint pjp) throws Throwable {
        return pjp.proceed();
    }

    @Override
    public int getOrder() {
        return -1;
    }
}
