//
//  QGQiNiuService.m
//  CreditWallet
//
//  Created by 逍遥子 on 2016/11/22.
//  Copyright © 2016年 QuantGroup. All rights reserved.
//

#import "QiniuService.h"

static QiniuService *shareService = nil;

@implementation QiniuService
/**
 *  唯一官方指定初始化方法
 *
 *  @return shareInstance
 */
+ (instancetype)shareInstance {
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        shareService = [[QiniuService alloc] init];
    });
    return shareService;
}

- (void)putData:(NSData *)data token:(NSString *)token key:(NSString *)key params:(NSDictionary *)params complete:(QNUpCompletionHandler)completionHandler progressHandler:(QNUpProgressHandler)progress {

    QNUploadOption *uploadOption = [[QNUploadOption alloc] initWithMime:@"image/jpeg"
                                                        progressHandler:^(NSString *key, float percent) {
                                                            if (progress) {
                                                                progress(key, percent);
                                                            }

                                                        }
                                                                 params:params
                                                               checkCrc:YES
                                                     cancellationSignal:nil];

    //    NSMutableDictionary *params =[[NSMutableDictionary alloc]init];
    //    [params setValue:@"" forKey:@""];
    //    uploadOption.params = params;

    QNUploadManager *upManager = [[QNUploadManager alloc] init];

    [upManager putData:data
                   key:key
                 token:token
              complete:^(QNResponseInfo *info, NSString *key, NSDictionary *resp) {

                  NSLog(@"info---%@", info);
                  NSLog(@"resp--返回%@", resp);

                  if (completionHandler) {
                      completionHandler(info, key, resp);
                  }

              }
                option:uploadOption];
}
- (void)putData:(NSData *)data zone:(QNZone *)zone token:(NSString *)token key:(NSString *)key params:(NSDictionary *)params complete:(QNUpCompletionHandler)completionHandler progressHandler:(QNUpProgressHandler)progress {

    QNUploadOption *uploadOption = [[QNUploadOption alloc] initWithMime:@"image/jpeg"
                                                        progressHandler:^(NSString *key, float percent) {
                                                            if (progress) {
                                                                progress(key, percent);
                                                            }

                                                        }
                                                                 params:params
                                                               checkCrc:YES
                                                     cancellationSignal:nil];

    //    NSMutableDictionary *params =[[NSMutableDictionary alloc]init];
    //    [params setValue:@"" forKey:@""];
    //    uploadOption.params = params;

    QNUploadManager *upManager = [[QNUploadManager alloc] initWithZone:zone];

    [upManager putData:data
                   key:key
                 token:token
              complete:^(QNResponseInfo *info, NSString *key, NSDictionary *resp) {

                  NSLog(@"%@", info);
                  NSLog(@"%@", resp);

                  if (completionHandler) {
                      completionHandler(info, key, resp);
                  }

              }
                option:uploadOption];
}

@end
