//
//  QGQiNiuService.h
//  CreditWallet
//
//  Created by 逍遥子 on 2016/11/22.
//  Copyright © 2016年 QuantGroup. All rights reserved.
//

#import "QiniuSDK.h"
#import <Foundation/Foundation.h>
@interface QiniuService : NSObject
/**
 *  唯一官方指定初始化方法
 *
 *  @return shareInstance
 */
+ (instancetype)shareInstance;

/**
 *    直接上传数据
 *
 *    @param data              待上传的数据
 *    @param key               上传到云存储的key，为nil时表示是由七牛生成
 *    @param completionHandler 上传完成后的回调函数
 *    @param progress          上传时进度的回调函数
 */
- (void)putData:(NSData *)data token:(NSString *)token key:(NSString *)key params:(NSDictionary *)params complete:(QNUpCompletionHandler)completionHandler progressHandler:(QNUpProgressHandler)progress;
/**
 *    直接上传数据
 *
 *    @param data              待上传的数据
 *    @param zone              zone
 *    @param key               上传到云存储的key，为nil时表示是由七牛生成
 *    @param completionHandler 上传完成后的回调函数
 *    @param progress          上传时进度的回调函数
 */
- (void)putData:(NSData *)data zone:(QNZone *)zone token:(NSString *)token key:(NSString *)key params:(NSDictionary *)params complete:(QNUpCompletionHandler)completionHandler progressHandler:(QNUpProgressHandler)progress;
@end
