//
//  SystemManager.m
//  CreditWallet
//
//  Created by 张博 on 16/8/26.
//  Copyright © 2016年 QuantGroup. All rights reserved.
//

#import "SystemManager.h"
#import "QGAppMacro.h"
#import "QGTalosNetwork.h"
#import "QGLoginRequestApi.h"
#import "QGCardRequestApi.h"
#import "QGCacheManager.h"
#import "DES3EncryptUtil.h"
#import "QGUserInfo.h"
#import "QGGlobalConst.h"
#import "NSString+CreditWallet.h"
#import "QGCalendarManager.h"
#import "QGUpdateAlertView.h"
#import "QGPasteAlertView.h"
#import "DeveloperFileManager.h"
#import "QGAnalyticsService.h"


///上次推荐更新提示的日期
#define VCCLastUpdateHintDate @"VCCLastUpdateHintDate"

@interface SystemManager()

/// 内部应用粘贴板字符串
@property (nonatomic, copy)NSString *pasteboardString;
/// 内部应用粘贴板字符串
@property (nonatomic, copy)NSArray *pasteboardStrings;

@end

static SystemManager * shareManager = nil;

@implementation SystemManager

+ (void)load
{
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        [SystemManager shareInstance];
    });
    
}

+ (instancetype)shareInstance
{
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        shareManager = [[SystemManager alloc]init];
    });
    return shareManager;
}



- (id)init
{
    self = [super init];
    if (self) {
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(pasteboardChanged) name:UIPasteboardChangedNotification object:nil];
    }
    return self;
}


/// 监听App的粘贴板
- (void)pasteboardChanged
{
    UIPasteboard *pasteboard = [UIPasteboard generalPasteboard];
    
    if (pasteboard.string.length) {
        /// 大于100 取 100
        if (pasteboard.string.length > 100) {
            self.pasteboardString = [pasteboard.string substringToIndex:99];
        }else{
            self.pasteboardString = pasteboard.string;
        }
        self.pasteboardStrings = pasteboard.strings;
        [[QGCacheManager shareCacheManager] setAPPConfigValue:self.pasteboardString forKey:kPasteboardCurrentContentKey];
    }else{
        self.pasteboardString = nil;
        self.pasteboardStrings = nil;
    }
}

#pragma mark - /*************************/


/// 刷新token接口，启动时调用
/// @param successBlock 成功回调
/// isSuccess = YES 请求成功并且业务处理成功，token可用  场景：刷新成功时调用（状态码为0000）
/// isSuccess = NO 请求成功业务处理失败，token不可用 场景：状态码非0000
/// @param failureBlock 网络请求失败回调
- (void)refreshTokenWithSuccess:(void(^)(BOOL isSuccess, NSString * token))successBlock failure:(void(^)(NSError * error))failureBlock
{
    //未登陆直接返回
    if (![QGUserInfo sharedUserInfo].isLogin) {
        if (failureBlock) {
            failureBlock(nil);
        }
        return;
    }
    
    //进入请求流程
    NSString * urlString = [QGLoginRequestApi urlWithQGLoginRequestServerMethod:QGLoginRequestServerMethodAuthRefreshToken];
    NSMutableDictionary * headerParam = [NSMutableDictionary dictionary];
    [headerParam setObject:[QGUserInfo sharedUserInfo].vccRefreshToken forKey:@"vcc-refresh-token"];
    
    [[QGTalosNetwork shareManager] GET:urlString headers:headerParam parameters:nil success:^(id  _Nonnull responseObject) {
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            NSDictionary * dataDic = responseObject[@"data"];
            [QGUserInfo sharedUserInfo].token = dataDic[@"token"];
            [QGUserInfo sharedUserInfo].vccRefreshToken = dataDic[@"vccRefreshToken"];
            [QGUserInfo sharedUserInfo].uuid = dataDic[@"uuid"];
            [QGUserInfo sharedUserInfo].userId = [NSString stringWithFormat:@"%@", dataDic[@"userId"]];;
            [QGUserInfo sharedUserInfo].userName = dataDic[@"phoneNo"];
            

            [[NSNotificationCenter defaultCenter] postNotificationName:ModelCenterUserRefreshToken object:nil];
            
            //添加刷新token成功
            QGAppBusinessStateEvent * event = [QGAppBusinessStateEvent abseEventWithPage:@"APP启动" action:@"刷新token" value:@"success" code:nil desc:nil phone:[QGUserInfo sharedUserInfo].userName];
            [QGAnalyticsService analyticsTrackWithEvent:event];
            
            //成功回调
            if (successBlock) {
                successBlock(YES, [QGUserInfo sharedUserInfo].token);
            }
        }
        else
        {
            //添加刷新token失败埋点
            QGAppBusinessStateEvent * event = [QGAppBusinessStateEvent abseEventWithPage:@"APP启动" action:@"刷新token" value:@"failed" code:responseObject[@"code"] desc:responseObject[@"msg"] phone:[QGUserInfo sharedUserInfo].userName];
            [QGAnalyticsService analyticsTrackWithEvent:event];
            
            //失败回调
            if (successBlock) {
                successBlock(NO, nil);
            }
            
            [QGUserInfo logOut];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        //添加刷新token失败埋点
        QGAppBusinessStateEvent * event = [QGAppBusinessStateEvent abseEventWithPage:@"APP启动" action:@"刷新token" value:@"failed" code:nil desc:nil phone:[QGUserInfo sharedUserInfo].userName];
        [QGAnalyticsService analyticsTrackWithEvent:event];
        
        //失败回调
        if (failureBlock) {
            failureBlock(error);
        }
    }];
}

#pragma mark - 检查升级
/// 检查升级
- (void)checkIsNeedUpdate
{
    NSString * urlString = [QGCardRequestApi urlWithIndex:QGCardRequestServerMethodAPPUpdata];
//    urlString = @"http://yapi.quantgroups.com/mock/305/app/config/version";
    [[QGTalosNetwork shareManager] GET:urlString parameters:nil success:^(id  _Nonnull responseObject) {
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            NSDictionary * dataDic = responseObject[@"data"];
            [self requestUpdateSuccessWithData:dataDic];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        
    }];
}

///请求成功处理
- (void)requestUpdateSuccessWithData:(NSDictionary *)dataDic
{
    //app更新类型，1强制更新，2推荐更新
    NSInteger updateType = [dataDic[@"updateType"] integerValue];
    NSString * downloadUrl = dataDic[@"downloadUrl"];
    NSString * content = dataDic[@"content"];
    NSString * title = dataDic[@"title"];
    
    //如果下载地址为空，后面不再执行
    if ([NSString isEmpty:downloadUrl]) {
        return;
    }
    
    //推荐更新每日一次
    if (updateType == 2) {
        NSDate * todayDate = [NSDate date];
        NSString * todayStr = [[QGCalendarManager shareInstance] getStringFromDate:todayDate formatter:@"yyyyMMdd"];
        NSString * lastUpdateHintDate = [[QGCacheManager shareCacheManager] userConfigInfoValueForKey:VCCLastUpdateHintDate];
        //本地有存储数据，并且日期与今天一致，说明今天已经提示过了，则不再提示
        if (![NSString isEmpty:lastUpdateHintDate] && [lastUpdateHintDate isEqualToString:todayStr]) {
            return;
        }
        //记录日期
        [[QGCacheManager shareCacheManager] setUserConfigInfoValue:todayStr forKey:VCCLastUpdateHintDate];
        [[NSNotificationCenter defaultCenter] postNotificationName:ModelCenterUserRefreshToken object:nil];
    }
    
    //弹出提示框
    QGUpdateAlertView * alertView = [[QGUpdateAlertView alloc] initWithUpdateType:updateType downloadUrl:downloadUrl title:title content:content];
    [alertView showInView:nil];
}

#pragma mark - 检查粘贴板
/// 检查粘贴板
- (void)checkPasteboard
{
    NSString * pasteboardStr = [UIPasteboard generalPasteboard].string;
    //发现粘贴行为弹窗
    if ([self validatePasteboardString]) {
        QGPasteAlertView * alertView = [[QGPasteAlertView alloc] initWithPasteStr:pasteboardStr];
        [alertView showInView:nil];
        
        //保存
         [[QGCacheManager shareCacheManager] setAPPConfigValue:pasteboardStr forKey:kPasteboardCurrentContentKey];
        self.pasteboardString = pasteboardStr;
//        //清空粘贴板
//        [UIPasteboard generalPasteboard].string = @"";
//        [QGCacheManager.shareCacheManager removeAppConfigWithKeys:@[kPasteboardCurrentContentKey]];
        __block NSString * searchText = pasteboardStr;
        alertView.searchBlock = ^{
            NSMutableDictionary *param = [NSMutableDictionary dictionary];
            [param setObject:searchText forKey:@"searchText"];
            [Mediator performTarget:ClassNameWithHeadType(QGHeaderTypeQGSearchMallResultViewController) parameters:param handlerBlock:nil];
        };
    }
}

/// 判断粘贴板的字符的有效性
- (BOOL)validatePasteboardString
{
    NSString *string = [UIPasteboard generalPasteboard].string;
    /// 空或者字符串长度小于15
    if ([NSString isEmpty:string] || string.length <= 15) return NO;
    if (self.pasteboardString.length == 0) {
        NSString *pasterBoard = [[QGCacheManager shareCacheManager] appConfigValueForKey:kPasteboardCurrentContentKey];
        if (pasterBoard.length) {
            self.pasteboardString = pasterBoard;
        }
    }
    /// 与粘贴板相同
    if (self.pasteboardString) {
        // 字符串大于100,取100
        if (string.length > 100) {
            NSString *subString = [string substringToIndex:99];
            if ([self.pasteboardString isEqualToString:subString]) {
                return NO;
            }
        }else{
            if ([self.pasteboardString isEqualToString:string]) {
                return NO;
            }
        }
    }
    /// 纯数字
    NSString *fiterStr = [string stringByReplacingOccurrencesOfString:@" " withString:@""];
    if ([fiterStr isNumber]) return NO;
    
    return YES;
}


#pragma mark - /*************************/
//自定义webviewUserAgent
+(void)custemWebViewUserAgent
{
    @autoreleasepool {
        UIWebView* tempWebView = [[UIWebView alloc] initWithFrame:CGRectZero];
        NSString* userAgent = [tempWebView stringByEvaluatingJavaScriptFromString:@"navigator.userAgent"];
        NSString *ua = [NSString stringWithFormat:@"%@ %@/%@",
                        userAgent,
                        @"VCC",XcodeAppVersion];
        [[NSUserDefaults standardUserDefaults] registerDefaults:@{@"UserAgent" : ua, @"User-Agent" : ua}];
#if !__has_feature(objc_arc)
        [tempWebView release];
#endif
    }
}

///保存默认的user-agent
+ (void)saveNormalUserAgent
{
    @autoreleasepool {
        UIWebView* tempWebView = [[UIWebView alloc] initWithFrame:CGRectZero];
        NSString* userAgent = [tempWebView stringByEvaluatingJavaScriptFromString:@"navigator.userAgent"];
        NSString *ua = [NSString stringWithFormat:@"%@ %@/%@",
                        userAgent,
                        @"VCC",XcodeAppVersion];
        [[NSUserDefaults standardUserDefaults] setObject:ua forKey:@"normalUserAgent"];
#if !__has_feature(objc_arc)
        [tempWebView release];
#endif
    }
    
}
///重置为默认的user-agent
+ (void)resetToNormalUserAgent
{
    NSString *ua = [[NSUserDefaults standardUserDefaults] objectForKey:@"normalUserAgent"];
    if (ua.length > 0) {
        [[NSUserDefaults standardUserDefaults] registerDefaults:@{@"UserAgent" : ua, @"User-Agent" : ua}];
    }
}
#pragma mark - /*************************/


///获取当前主Window
+ (UIWindow *)getKeyWindow
{
    NSEnumerator *frontToBackWindows = [UIApplication.sharedApplication.windows reverseObjectEnumerator];
    UIWindow * keyWindow = nil;
    for (UIWindow *window in frontToBackWindows){
        BOOL windowOnMainScreen = window.screen == UIScreen.mainScreen;
        BOOL windowIsVisible = !window.hidden && window.alpha > 0;
        BOOL windowLevelNormal = window.windowLevel == UIWindowLevelNormal;
        
        if (windowOnMainScreen && windowIsVisible && windowLevelNormal) {
            keyWindow = window;
            break;
        }
    }
    return keyWindow;
}

+ (CGFloat)visibleKeyboardHeight {
#if !defined(SV_APP_EXTENSIONS)
    UIWindow *keyboardWindow = nil;
    for (UIWindow *testWindow in [[UIApplication sharedApplication] windows]) {
        if(![[testWindow class] isEqual:[UIWindow class]]) {
            keyboardWindow = testWindow;
            break;
        }
    }
    
    for (__strong UIView *possibleKeyboard in [keyboardWindow subviews]) {
        if ([possibleKeyboard isKindOfClass:NSClassFromString(@"UIPeripheralHostView")] || [possibleKeyboard isKindOfClass:NSClassFromString(@"UIKeyboard")]) {
            return CGRectGetHeight(possibleKeyboard.bounds);
        } else if ([possibleKeyboard isKindOfClass:NSClassFromString(@"UIInputSetContainerView")]) {
            for (__strong UIView *possibleKeyboardSubview in [possibleKeyboard subviews]) {
                if ([possibleKeyboardSubview isKindOfClass:NSClassFromString(@"UIInputSetHostView")]) {
                    return CGRectGetHeight(possibleKeyboardSubview.bounds);
                }
            }
        }
    }
#endif
    return 0;
}


- (void)dealloc
{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}

@end
