//
//  SwizzleMethod.m
//  VirtualPayment
//
//  Created by 张博 on 2019/5/8.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "SwizzleMethod.h"
#import <objc/runtime.h>
@implementation SwizzleMethod


/**
 *  获取class的originalSelector 替换成 swizzledSelector
 *
 *  @param class            目标类
 *  @param originalSelector 目标方法
 *  @param swizzledSelector 替换之后的方法
 */
void swizzleMethod(Class class, SEL originalSelector, SEL swizzledSelector)
{
    //获取两个Method
    Method originalMethod = class_getInstanceMethod(class, originalSelector);
    Method swizzledMethod = class_getInstanceMethod(class, swizzledSelector);
    //添加被交换的方法 看下是否存在该方法
    BOOL didAddMethod = class_addMethod(class,
                                        originalSelector,
                                        method_getImplementation(swizzledMethod),
                                        method_getTypeEncoding(swizzledMethod));
    //创建成功 则说明不存在方法 把空方法替换
    if (didAddMethod) {
        class_replaceMethod(class, swizzledSelector, method_getImplementation(originalMethod), method_getTypeEncoding(originalMethod));
    }
    else
    {
        method_exchangeImplementations(originalMethod, swizzledMethod);
        
    }
}
@end
