//
//  ZHWeChatTool.m
//  CreditWallet
//
//  Created by 张博 on 16/9/2.
//  Copyright © 2016年 QuantGroup. All rights reserved.
//

#import "ZHWeChatTool.h"
#import "SDWebImageDownloader.h"
#import "UIImage+CreditWallet.h"
#import "WXApi.h"
#import "QGAppMacro.h"
#import "QGHUDManager.h"
@interface ZHWeChatTool () <WXApiDelegate>

@end

@implementation ZHWeChatTool
static ZHWeChatTool *chatTool = nil;
/**
 *  唯一指定初始化方法 内部会自动注册微信APP ID
 */

+ (instancetype)share {
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        if (!chatTool) {
            chatTool = [[ZHWeChatTool alloc] init];
            [chatTool wxInit];
        }
    });
    return chatTool;
}

/**
 *  微信初始化
 */
- (void)wxInit {
    [WXApi registerApp:WXAppId];
}

/**
 *  微信是否安装
 */
- (BOOL)isWXInstalled {
    return [WXApi isWXAppInstalled];
}

/// 打开微信APP
- (BOOL)openWXApp
{
    return [WXApi openWXApp];
}

/// 微信登陆
- (void)WXLogin
{
    if (![self isWXInstalled]) {
        [QGHUDManager showHud:@"请您安装微信后，再尝试授权"];
        return;
    }
    
    //构造SendAuthReq结构体
    SendAuthReq* req = [[SendAuthReq alloc]init];
    req.scope = @"snsapi_userinfo";
    req.state = @"wechat_sdk_VCC";
    //第三方向微信终端发送一个SendAuthReq消息结构
    [WXApi sendReq:req];
}

/**
 *  微信分享
 *  @param dic   字典内包含的key @[imgUrl,image,title,desc,link]
 *  @param scene  发送的目标场景，可以选择发送到会话(WXSceneSession)或者朋友圈(WXSceneTimeline)。 默认发送到会话。
 */
- (void)WXShareWithDic:(NSDictionary *)dic scene:(int)scene {
    if (![self isWXInstalled]) {
        [QGHUDManager showHud:@"未安装微信客户端" afterDelay:1.5];
        return;
    }

    NSString * imageUrl = dic[@"imgUrl"];
    if ([imageUrl isKindOfClass:[NSString class]] && imageUrl.length > 0) {
        __weak typeof(self) weakSelf = self;
        [self downloaderImageWebpageObjectWithUrl:imageUrl successBlock:^(NSData *data) {
            [weakSelf sendToWXWebpageObjectWithImageData:data dic:dic scene:scene];
        }];
    } else {
        NSData *imageData = UIImagePNGRepresentation([UIImage imageNamed:@"share_icon"]);
        [self sendToWXWebpageObjectWithImageData:imageData dic:dic scene:scene];
    }
}


/// 微信图片分享
/// @param dic 分析字典
/// @param scene 发送的目标场景，可以选择发送到会话(WXSceneSession)或者朋友圈(WXSceneTimeline)。 默认发送到会话。
- (void)WXShareImageObjectWithDic:(NSDictionary *)dic scene:(int)scene
{
    if (![self isWXInstalled]) {
        [QGHUDManager showHud:@"未安装微信客户端" afterDelay:1.5];
        return;
    }
    NSString * imageUrl = dic[@"imgUrl"];
    if ([imageUrl isKindOfClass:[NSString class]] && imageUrl.length > 0) {
        __weak typeof(self) weakSelf = self;
        [self downloaderImageObjectWithUrl:imageUrl successBlock:^(NSData *data, UIImage *image) {
            [weakSelf sendToWXImageObjectWithImageData:data dic:dic scene:scene];
        }];
    } else {
        UIImage * image = dic[@"image"];
        if (image && [image isKindOfClass:[UIImage class]]) {
            NSData * imageData = UIImagePNGRepresentation(image);
            [self sendToWXImageObjectWithImageData:imageData dic:dic scene:scene];
        }
        else
        {
            [QGHUDManager showHud:@"分享失败"];
        }
    }
}



/// 网页分享，下载图片并且压缩处理，如果未下载到则返回默认分享图片二进制
- (void)downloaderImageWebpageObjectWithUrl:(NSString *)urlString successBlock:(void(^)(NSData * data))successBlock
{
    [self downloaderImageObjectWithUrl:urlString successBlock:^(NSData *data, UIImage *image) {
        NSData * imageData = UIImageJPEGRepresentation([image imageByScalingAndCroppingForTargetSize:CGSizeMake(160, 160)], .5);
        //网页分享图片限制大小
        if (imageData.length > 32 * 1024) {
            imageData = UIImagePNGRepresentation([UIImage imageNamed:@"share_icon"]);
        }
        if (successBlock) {
            successBlock(imageData);
        }
    }];
}



/// 下载图片数据，并且不做任何处理
- (void)downloaderImageObjectWithUrl:(NSString *)urlString successBlock:(void(^)(NSData * data, UIImage * image))successBlock
{
    
    NSURL *imageUrl = [NSURL URLWithString:urlString];
    [[SDWebImageDownloader sharedDownloader] downloadImageWithURL:imageUrl options:SDWebImageDownloaderLowPriority progress:nil completed:^(UIImage * _Nullable image, NSData * _Nullable data, NSError * _Nullable error, BOOL finished) {
        if (data) {
            if (successBlock) {
                successBlock(data,image);
            }
        } else {
            dispatch_async(dispatch_get_main_queue(), ^{
                [QGHUDManager showHud:@"分享失败" afterDelay:1];
            });
        }
    }];
}




/// 图片分享
- (void)sendToWXImageObjectWithImageData:(NSData *)imageData dic:(NSDictionary *)dic scene:(int)scene
{
    WXMediaMessage *message = [WXMediaMessage message];
    NSString *title = dic[@"title"];

    if (title.length > 120) {
        title = [title substringToIndex:120];
    }

    message.title = title;
    if ([dic[@"desc"] length] > 140) {
        message.description = [dic[@"desc"] substringToIndex:139];
    } else {
        message.description = dic[@"desc"];
    }

    WXImageObject *ext = [WXImageObject object];
    ext.imageData = imageData;

    message.mediaObject = ext;

    SendMessageToWXReq *req = [[SendMessageToWXReq alloc] init];
    req.bText = NO;
    req.message = message;
    req.scene = scene;

    if (![WXApi sendReq:req]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [QGHUDManager showHud:@"分享失败" afterDelay:1];
        });
    }
}


//网页多媒体分享
- (void)sendToWXWebpageObjectWithImageData:(NSData *)imageData dic:(NSDictionary *)dic scene:(int)scene {
    WXMediaMessage *message = [WXMediaMessage message];
    NSString *title = dic[@"title"];

    if (title.length > 120) {
        title = [title substringToIndex:120];
    }

    message.title = title;
    if ([dic[@"desc"] length] > 140) {
        message.description = [dic[@"desc"] substringToIndex:139];
    } else {
        message.description = dic[@"desc"];
    }

    message.thumbData = imageData;
    WXWebpageObject *ext = [WXWebpageObject object];
    ext.webpageUrl = dic[@"link"];

    message.mediaObject = ext;

    SendMessageToWXReq *req = [[SendMessageToWXReq alloc] init];
    req.bText = NO;
    req.message = message;
    req.scene = scene;

    if (![WXApi sendReq:req]) {
        dispatch_async(dispatch_get_main_queue(), ^{
            [QGHUDManager showHud:@"分享失败" afterDelay:1];
        });
    }
}

/**
 *  分享文本到微信
 *
 *  @param text  文本信息
 *  @param scene 发送的目标场景，可以选择发送到会话(WXSceneSession)或者朋友圈(WXSceneTimeline)。 默认发送到会话
 */
- (void)shareTextToWXWithText:(NSString *)text scene:(int)scene {
    WXTextObject *message = [WXTextObject object];
    if (text.length == 0) {
        text = @"未获取到数据";
    }
    message.contentText = text;

    //    NSData * data = [text dataUsingEncoding:NSUTF8StringEncoding];

    SendMessageToWXReq *req = [[SendMessageToWXReq alloc] init];
    req.bText = YES;
    req.text = text;
    req.scene = scene;
    if (![WXApi sendReq:req]) {
        [QGHUDManager showHud:@"分享失败" afterDelay:1];
    }
}

/**
 *  微信支付
 *
 *  @param payInfoDic   微信支付需要的必穿参数
 *  @param successBlock 支付回调
 */
- (void)WXPayWithPayinfoDic:(NSDictionary *)payInfoDic result:(void (^)(BOOL isSuccess))successBlock {
    if (![self isWXInstalled]) {
        [QGHUDManager showHud:@"未安装微信客户端" afterDelay:1.5];
        return;
    }
    NSMutableString *stamp = [payInfoDic objectForKey:@"timestamp"];
    //调起微信支付
    PayReq *req = [[PayReq alloc] init];
    req.openID = [NSString stringWithFormat:@"%@", [payInfoDic objectForKey:@"appid"]];
    req.nonceStr = [NSString stringWithFormat:@"%@", [payInfoDic objectForKey:@"noncestr"]];
    req.package = [NSString stringWithFormat:@"%@", [payInfoDic objectForKey:@"package"]];
    req.partnerId = [NSString stringWithFormat:@"%@", [payInfoDic objectForKey:@"partnerid"]];
    req.prepayId = [NSString stringWithFormat:@"%@", [payInfoDic objectForKey:@"prepayid"]];
    req.sign = [NSString stringWithFormat:@"%@", [payInfoDic objectForKey:@"sign"]];
    req.timeStamp = stamp.intValue;

    BOOL flag = [WXApi sendReq:req];
    if (!flag) {
        NSLog(@"请求微信失败");
        [QGHUDManager showHud:@"对不起，微信调用失败\n错误：未知"];
    } else {
        NSLog(@"请求成功");
    }

    self.wxPayBlock = ^(BOOL isSuccess, NSString *msg) {
        if (successBlock) {
            successBlock(isSuccess);
        }
    };
}

#pragma mark - Req
/*! @brief 收到一个来自微信的请求，第三方应用程序处理完后调用sendResp向微信发送结果
 *
 * 收到一个来自微信的请求，异步处理完成后必须调用sendResp发送处理结果给微信。
 * 可能收到的请求有GetMessageFromWXReq、ShowMessageFromWXReq等。
 * @param req 具体请求内容，是自动释放的
 */
- (void)onReq:(BaseReq *)req {
    NSLog(@"weixin return req");

    if ([req isKindOfClass:[GetMessageFromWXReq class]]) {
        // 微信请求App提供内容， 需要app提供内容后使用sendRsp返回
        NSString *strTitle = [NSString stringWithFormat:@"微信请求App提供内容"];
        NSString *strMsg = @"微信请求App提供内容，App要调用sendResp:GetMessageFromWXResp返回给微信";
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:strTitle message:strMsg delegate:self cancelButtonTitle:@"OK" otherButtonTitles:nil, nil];
        alert.tag = 1000;
        [alert show];
    } else if ([req isKindOfClass:[ShowMessageFromWXReq class]]) {
        ShowMessageFromWXReq *temp = (ShowMessageFromWXReq *) req;
        WXMediaMessage *msg = temp.message;

        //显示微信传过来的内容
        WXAppExtendObject *obj = msg.mediaObject;

        NSString *strTitle = [NSString stringWithFormat:@"微信请求App显示内容"];
        NSString *strMsg = [NSString stringWithFormat:@"标题：%@ \n内容：%@ \n附带信息：%@ \n缩略图:%lu bytes\n\n", msg.title, msg.description, obj.extInfo, (unsigned long) msg.thumbData.length];

        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:strTitle message:strMsg delegate:self cancelButtonTitle:@"OK" otherButtonTitles:nil, nil];
        [alert show];
    } else if ([req isKindOfClass:[LaunchFromWXReq class]]) {
        //从微信启动App
        NSString *strTitle = [NSString stringWithFormat:@"从微信启动"];
        NSString *strMsg = @"这是从微信启动的消息";

        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:strTitle message:strMsg delegate:self cancelButtonTitle:@"OK" otherButtonTitles:nil, nil];
        [alert show];
    }
}

#pragma mark - resp
/*! @brief 发送一个sendReq后，收到微信的回应
 *
 * 收到一个来自微信的处理结果。调用一次sendReq后会收到onResp。
 * 可能收到的处理结果有SendMessageToWXResp、SendAuthResp等。
 * @param resp具体的回应内容，是自动释放的
 */
- (void)onResp:(BaseReq *)resp {
    if ([resp isKindOfClass:[SendAuthResp class]]) {
        SendAuthResp *authResp = (SendAuthResp *) resp;
        if (authResp.errCode == 0) {
            NSString *code = authResp.code;
//            NSLog(@"微信登录————code = %@",code);
            [self getUserInfoWithCode:code];
//            [self getAccessTokenWithCode:code];
        } else {
            [QGHUDManager showHud:@"获取授权信息失败" afterDelay:1.8];
        }
    } else if ([resp isKindOfClass:[PayResp class]]) {
        PayResp *resPay = (PayResp *) resp;
        int code = resPay.errCode;
        if (code == 0) {
            [QGHUDManager showHud:@"支付成功" afterDelay:1.8];
            if (self.wxPayBlock) {
                self.wxPayBlock(YES, @"支付成功");
            }

        } else if (code == -1) {
            [QGHUDManager showHud:@"支付失败" afterDelay:1.8];
            if (self.wxPayBlock) {
                self.wxPayBlock(NO, @"支付失败");
            }
        } else if (code == -2) {
            [QGHUDManager showHud:@"用户取消支付" afterDelay:1.8];
            if (self.wxPayBlock) {
                self.wxPayBlock(NO, @"用户取消支付");
            }
        }
    } else if ([resp isKindOfClass:[SendMessageToWXResp class]]) {
        SendMessageToWXResp *messageResp = (SendMessageToWXResp *) resp;
        int code = messageResp.errCode;
        if (code == 0) {
//            [QGHUDManager showHud:@"分享成功" afterDelay:1.8];
            if (self.wxShareResultBlock) {
                self.wxShareResultBlock(YES);
            }
        } else if (code == -1) {
//            [QGHUDManager showHud:@"分享失败" afterDelay:1.8];
            if (self.wxShareResultBlock) {
                self.wxShareResultBlock(NO);
            }
        } else if (code == -2) {
//            [QGHUDManager showHud:@"分享取消" afterDelay:1.8];
            if (self.wxShareResultBlock) {
                self.wxShareResultBlock(NO);
            }
        }
    }
}

/*! @brief 处理微信通过URL启动App时传递的数据
 *
 * 需要在 application:openURL:sourceApplication:annotation:或者application:handleOpenURL中调用。
 * @param url 微信启动第三方应用时传递过来的URL
 * @return 成功返回YES，失败返回NO。
 */
- (BOOL)handleOpenURL:(NSURL *)url {
    return [WXApi handleOpenURL:url delegate:self];
}

///根据code获取用户信息
- (void)getUserInfoWithCode:(NSString *)code
{
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        
        //第一步获取access_token
        NSString * getAccessTokenStr =[NSString stringWithFormat:@"https://api.weixin.qq.com/sns/oauth2/access_token?appid=%@&secret=%@&code=%@&grant_type=authorization_code",WXAppId,WXSecret,code];
        NSURL * getAccessTokenUrl = [NSURL URLWithString:getAccessTokenStr];
        NSString * accessTokenResponseStr = [NSString stringWithContentsOfURL:getAccessTokenUrl encoding:NSUTF8StringEncoding error:nil];
        NSData *accessTokenResponseData = [accessTokenResponseStr dataUsingEncoding:NSUTF8StringEncoding];
        
        //获取数据成功 解析access_tokenDic
        NSDictionary * accessTokenResponseDic;
        //安全判断
        if (accessTokenResponseData) {
            /*
            {
              "access_token": "ACCESS_TOKEN",
              "expires_in": 7200,
              "refresh_token": "REFRESH_TOKEN",
              "openid": "OPENID",
              "scope": "SCOPE",
              "unionid": "o6_bmasdasdsad6_2sgVt7hMZOPfL"
            }
             */
            accessTokenResponseDic = [NSJSONSerialization JSONObjectWithData:accessTokenResponseData options:NSJSONReadingMutableContainers error:nil];
            
            
            //第二步获取用户信息
            NSString *getUserInfoStr =[NSString stringWithFormat:@"https://api.weixin.qq.com/sns/userinfo?access_token=%@&openid=%@",accessTokenResponseDic[@"access_token"],accessTokenResponseDic[@"openid"]];
            NSURL * getUserInfoUrl = [NSURL URLWithString:getUserInfoStr];
            NSString * userInfoResponseStr = [NSString stringWithContentsOfURL:getUserInfoUrl encoding:NSUTF8StringEncoding error:nil];
            QGWechatLoginInfoModel * infoModel = [QGWechatLoginInfoModel yy_modelWithJSON:userInfoResponseStr];
            //检测能否拿到openid
            if (infoModel.openid) {
                /*
                {
                  "openid": "OPENID",
                  "nickname": "NICKNAME",
                  "sex": 1,
                  "province": "PROVINCE",
                  "city": "CITY",
                  "country": "COUNTRY",
                  "headimgurl": "http://wx.qlogo.cn/mmopen/g3MonUZtNHkdmzicIlibx6iaFqAc56vxLSUfpb6n5WKSYVY0ChQKkiaJSgQ1dZuTOgvLLrhJbERQQ4eMsv84eavHiaiceqxibJxCfHe/0",
                  "privilege": ["PRIVILEGE1", "PRIVILEGE2"],
                  "unionid": " o6_bmasdasdsad6_2sgVt7hMZOPfL"
                }
                */

                
                //丢入主线程，回调出去
                dispatch_async(dispatch_get_main_queue(), ^{
                    if (self.authSuccessBlock) {
                        self.authSuccessBlock(infoModel);
                    }
                });
                
            }
        }
        
        
    });
}


@end

@implementation QGWechatLoginInfoModel



@end
