//
//  QGThirdPlatformService.h
//  CreditWallet
//
//  Created by 张博 on 16/9/2.
//  Copyright © 2016年 QuantGroup. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "ZHWeChatTool.h"

typedef NS_ENUM(NSInteger,QGShareItemType){
    QGShareItemTypeWeChat = 1, // 微信好友
    QGShareItemTypeTimeLine,   // 微信朋友圈
    QGShareItemTypeQQ,         // QQ好友
    QGShareItemTypeQQZone,     // QQ空间
    QGShareItemTypeCopyLink    // 复制链接
};

@interface QGThirdPlatformService : NSObject


/**
 *  唯一官方指定初始化方法
 *
 *  @return shareInstance
 */
+(instancetype)shareInstance;


/// 打开微信APP
- (BOOL)openWXApp;


/**
 *  分享多媒体方法
 *
 *  @param type        分享到那个平台
 *  @param dic         分享的字典 dic allkeys (imgUrl,image,title,desc,link)
 *  @param resultBlock 分享回调
 */
-(void)shareWithType:(QGShareItemType)type dictionary:(NSDictionary *)dic resultBlock:(void(^)(BOOL isSuccess))resultBlock;

/**
*  分享图片方法
*  @param type        分享到那个平台
*  @param dic         分享的字典 dic allkeys (imgUrl,image,title,desc,link)
*  @param resultBlock 分享回调
*/
- (void)shareImageWithType:(QGShareItemType)type dictionary:(NSDictionary *)dic resultBlock:(void(^)(BOOL isSuccess))resultBlock;

/**
 *  分享文本信息
 *
 *  @param type        分享到那个平台
 *  @param text        分享的文本
 *  @param resultBlock 分享回调
 */
- (void)shareTextWithType:(QGShareItemType)type text:(NSString *)text resultBlock:(void(^)(BOOL isSuccess))resultBlock;


/**
 *  微信支付
 *
 *  @param payInfoDic   微信支付需要的必穿参数
 *  @param successBlock 支付回调
 */
- (void)wxPayWithPayinfoDic:(NSDictionary *)payInfoDic result:(void(^)(BOOL isSuccess))successBlock;


/// 微信登录
/// @param successBlock 成功回调
- (void)wxAuthWithSuccess:(void(^)(QGWechatLoginInfoModel * infoModel))successBlock;

/**
 *  第三方平台回调
 *
 *  @param url      回调URL
 *  @param delegate 代理设置
 *
 *  @return 成功 YES 否则 NO
 */
-(BOOL)handleOpenURL:(NSURL *) url delegate:(id) delegate;
@end
