//
//  QGTencentTool.h
//  CreditWallet
//
//  Created by harry on 07/11/2017.
//  Copyright © 2017 QuantGroup. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef NS_ENUM(NSUInteger, QGTencentToolType) {
    QGTencentToolTypeQQ, ///QQ好友
    QGTencentToolTypeQQZone, ///QQ空间
};


///分享回调
typedef void(^QGTencenthareResultBlock)(BOOL isSuccess);

//-----------------------------------------------------------------------/

@interface QGTencentTool : NSObject
/**
 *  分享回调Block
 */
@property (nonatomic, copy) QGTencenthareResultBlock qqShareResultBlock;


//-----------------------------------------------------------------------/

/**
 *  唯一指定初始化方法 内部会自动注册微信APP ID
 */
+(instancetype)share;



/**
 *  QQ是否安装
 *
 *  @return BOOL结果
 */
- (BOOL)isQQInstalled;



/**
 *  QQ分享多媒体信息
 *
 *  @param dic   字典内包含的key @[imgUrl,title,desc,link]
 */
-(void)QQShareWithDic:(NSDictionary *)dic shareType:(QGTencentToolType)shareType;


/// 分享图片
/// @param dic   字典内包含的key @[imgUrl,title,desc,link]
- (void)QQShareImageWithDic:(NSDictionary *)dic shareType:(QGTencentToolType)shareType;

/**
 *  分享文本到QQ
 *
 *  @param text  文本信息
 */
- (void)shareTextToQQWithText:(NSString *)text shareType:(QGTencentToolType)shareType;


/* 处理QQ通过URL启动App时传递的数据
 *
 * 需要在 application:openURL:sourceApplication:annotation:或者application:handleOpenURL中调用。
 * @param url QQ启动第三方应用时传递过来的URL
 * @return 成功返回YES，失败返回NO。
 */
- (BOOL)handleOpenURL:(NSURL *) url;

@end
