//
//  QGPushService.h
//  CreditWallet
//
//  Created by 张博 on 17/1/22.
//  Copyright © 2017年 QuantGroup. All rights reserved.
//

#import <Foundation/Foundation.h>


@interface QGPushService : NSObject

+ (instancetype)sharedQGPushService;

///加载推送基础信息
+(void)loadQGPushConfig:(NSDictionary *)launchOptions;

///注册推送
+(void)registerQGPush;

///绑定deviceToken
+(void)bindDeviceToken:(NSData *)deviceToken;

///处理收到的 APNs 消息
+ (void)handleRemoteNotification:(NSDictionary *)remoteInfo;

///设置推送账号
+ (void)setPushAccount:(NSString *)account;

///取消推送账号
+ (void)unsetPushAccount:(NSString *)account;

//发送本地通知，用于清空应用图标角标，但不影响消息通知栏中的消息
+ (void)clearApplicationIconBadgeNumber;
@end
