//
//  QGToolsConfig.m
//  VirtualPayment
//
//  Created by 张博 on 2019/6/26.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGToolsConfig.h"
#import "QGGlobalConst.h"
@implementation QGToolsConfig

/**
 根据类型获取具体的目标字符串
 */
+(NSString *)getAppKeyWithToolsType:(QGToolsConfigType)type
{
    NSString *appKey;
    NSString *identifier = [[NSBundle mainBundle] bundleIdentifier];
    NSMutableDictionary *toolsDic =[[NSMutableDictionary alloc]initWithCapacity:0];
    //友盟key
    if (type == QGToolsConfigTypeUMeng) {
        [toolsDic addEntriesFromDictionary:[self getUMengConfigDictionary]];
    }
    //APPStore地址
    else if (type == QGToolsConfigTypeAppStoreURL)
    {
        [toolsDic addEntriesFromDictionary:[self getAppStoreURLDictionary]];
        
    }
    //渠道
    else if (type == QGToolsConfigTypeAppChannel)
    {
        [toolsDic addEntriesFromDictionary:[self getAppChannelDictionary]];
    }
    
    appKey =[toolsDic objectForKey:identifier];
    
    //没有APPKey 强制闪退
    NSAssert(appKey.length != 0, @"未获取到APPKey");
    
    return appKey;
}

/**
 友盟key
 */
+(NSDictionary *)getUMengConfigDictionary
{
    NSMutableDictionary *dic =[[NSMutableDictionary alloc]init];
    [dic setValue:@"5458a473fd98c55e06002923" forKey:@"com.quantgroup.www"];
    [dic setValue:@"58526368cae7e730e60018f0" forKey:@"com.xinyongqianbaonew.www"];
    [dic setValue:@"585a6c2f4ad156123f001c42" forKey:@"com.xyqbfroJisu.www"];
    [dic setValue:@"56cfbd09e0f55a95d3000503" forKey:@"com.xyqbFroOfficial.www"];
    [dic setValue:@"57a336f7e0f55a47aa003a06" forKey:@"com.newxyqb.www"];
    [dic setValue:@"57bd76a567e58ed90800475c" forKey:@"com.dkqianbao.com"];
    [dic setValue:@"57bea4ad67e58eb7d5002de7" forKey:@"com.quantgroup.test"];
    [dic setValue:@"57bea4ad67e58eb7d5002de7" forKey:@"com.quantgroup.test1"];
    [dic setValue:@"57639d0767e58eb5b9002b1d" forKey:@"com.xyqbJiSuBan.www"];
    [dic setValue:@"4717fe31f3e4f1d9c1c57604" forKey:@"com.fqdpro.www"];
    [dic setValue:@"5a4b5efff29d9847670000fd" forKey:@"com.baitiao.www"];
    [dic setValue:@"5d356561570df3b61a0003d9" forKey:@"com.financial.virtualcard"];
    
    return dic;
}


/**
 跳转的URL
 */
+(NSDictionary *)getAppStoreURLDictionary
{
    NSMutableDictionary *dic =[[NSMutableDictionary alloc]init];
    [dic setValue:ModelCenterMainAppStoreURL forKey:@"com.quantgroup.www"];
    return dic;
}

/**
 渠道号
 */
+(NSDictionary *)getAppChannelDictionary
{
    NSMutableDictionary *dic =[[NSMutableDictionary alloc]init];
    [dic setValue:@"AppStore" forKey:@"com.quantgroup.www"];  //正式版
    [dic setValue:@"AppStore-Test" forKey:@"com.quantgroup.test"]; //测试版
    [dic setValue:@"AppStore-virtualcard" forKey:@"com.baitiao.www"];
    [dic setValue:@"AppStore-virtualcard" forKey:@"com.financial.virtualcard"];
    return dic;
}


/*  小米push
 com.financial.virtualcard
 AppID:2882303761518073194
 AppKey:5961807384194
 
 com.baitiao.www
 AppID:2882303761518053418
 AppKey:5261805371418
 
 
 */


@end
