//
//  QGTalosNetwork.m
//  VirtualPayment
//
//  Created by 张博 on 2020/2/13.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGTalosNetwork.h"
#import "QGAppMacro.h"
#import "QGGlobalConst.h"
#import "QGUserInfo.h"
#import "QGToolsConfig.h"
#import <AdSupport/AdSupport.h>
#import "NSString+CreditWallet.h"

@implementation QGTalosNetwork

+ (instancetype)shareManager {
    static QGTalosNetwork *manager = nil;
    static dispatch_once_t pred;
    dispatch_once(&pred, ^{
        manager = [[self alloc] init];
    });
    return manager;
}


#pragma mark - Login & Logout
///刷新Token
- (void)refreshToken
{
    //刷新token时需要重置请求构造器
    [self resetRequestSerializer];
    [self configHTTPHeaders];
}

- (instancetype)init
{
    if (self = [super init]) {
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(refreshToken) name:ModelCenterUserLoginNotification object:nil];
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(refreshToken) name:ModelCenterUserLogOutNotification object:nil];
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(refreshToken) name:ModelCenterUserRefreshToken object:nil];
    }
    return self;
}


///配置通用header
- (void)configHTTPHeaders
{
    NSString *version = XcodeAppVersion;
    [self setRequestHTTPHeaderValue:version forkey:@"version"];
    [self setRequestHTTPHeaderValue:appChannel forkey:@"appChannel"];
    NSString *idfaStr = [[[ASIdentifierManager sharedManager] advertisingIdentifier] UUIDString];
    [self setRequestHTTPHeaderValue:idfaStr forkey:@"idfa"];
    [self setRequestHTTPHeaderValue:registerFrom forkey:@"vccChannel"];
    [self setRequestHTTPHeaderValue:@"zhenxianghua" forkey:@"appName"];
    [self configToken];
}


///配置token
- (void)configToken
{
    NSString *token = [QGUserInfo sharedUserInfo].token;
    if (![NSString isEmpty:token]) {
        [self setRequestHTTPHeaderValue:token forkey:@"x-auth-token"];
    }
}

- (void)requestSuccessCallBackWithURL:(NSString *)urlString opt:(NSString *)opt parameters:(NSDictionary *)parameters responseObject:(id)responseObject success:(BaseRequestSuccessBlock)success
{
    [super requestSuccessCallBackWithURL:urlString opt:opt parameters:parameters responseObject:responseObject success:success];
    
    //解析 businessCode 查看token是否过期
    if (responseObject && [responseObject isKindOfClass:[NSDictionary class]]) {
        NSString * businessCode = responseObject[@"businessCode"];
        //token 鉴权失败,需要退出登录
        if ([businessCode isEqualToString:@"0401"]) {
            [QGUserInfo logOut];
        }
    }
}

///请求失败的回调
- (void)requestFailureWithURL:(NSString *)urlString opt:(NSString *)opt parameters:(NSDictionary *)parameters error:(NSError *)error task:(NSURLSessionDataTask * )task failure:(BaseRequestFailureBlock)failure
{
    [super requestFailureWithURL:urlString opt:opt parameters:parameters error:error task:task failure:failure];
    
    //网络层的通用处理有时候会到这里
    NSData * errorData = error.userInfo[AFNetworkingOperationFailingURLResponseDataErrorKey];
    if ([errorData isKindOfClass:[NSData class]] && errorData.length > 0) {
        NSDictionary * jsonObj = [NSJSONSerialization JSONObjectWithData:errorData options:NSJSONReadingAllowFragments error:nil];
        if (jsonObj && [jsonObj isKindOfClass:[NSDictionary class]]) {
            NSString * businessCode = jsonObj[@"businessCode"];
            if ([businessCode isEqualToString:@"0401"]) {
                [QGUserInfo logOut];
            }
            
        }
    }
 
    
}

- (NSString *)baseUrlString
{
    return [NSString stringWithFormat:@"%@/",AppTalosBaseUrl];
}

- (void)dealloc
{
    [[NSNotificationCenter defaultCenter] removeObserver:self name:ModelCenterUserLoginNotification object:nil];
    [[NSNotificationCenter defaultCenter] removeObserver:self name:ModelCenterUserLogOutNotification object:nil];
    [[NSNotificationCenter defaultCenter] removeObserver:self name:ModelCenterUserRefreshToken object:nil];
}
@end
