//
//  QGChainManager.m
//  VirtualPayment
//
//  Created by silicn on 2019/8/2.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGDependChainManager.h"
#import "QGBaseNetwork.h"

#import "QGTalosNetwork.h"

@interface QGDependChainManager()

/// 本次请求的未知参数，一般由上次请求结果得到  Notice：第一个Request ,NextParam is always nil
@property (nonatomic, strong, nullable)NSDictionary *unknowParam;

//@property (nonatomic, strong)NSLock *lock;

/// 停止在此之后的所有的请求 ，Notice :当前正在执行的无法停止
@property (atomic, assign) BOOL stopThisLater;

@property (nonatomic, strong)dispatch_queue_t queue;

@property (nonatomic, strong)dispatch_semaphore_t semaphore ;

@end

@implementation QGDependChainManager

+ (instancetype)manager
{
    return [[QGDependChainManager alloc]init];
}

- (instancetype)init
{
    self = [super init];
    if (self) {
        // 初始化串行队列
        self.queue = dispatch_queue_create("com.quantgroup.queue.chain.request", DISPATCH_QUEUE_SERIAL);
        // 创建信号量
        self.semaphore = dispatch_semaphore_create(0);
    }
    return self;
}

- (QGDependChainManager * (^)(NSString *className,NSString *method,NSString *url,NSDictionary *knowParam, ChainRequestResultBlock result))then
{
    return ^(NSString *className,NSString *method,NSString *url,NSDictionary *knowParam, ChainRequestResultBlock result){
        
        dispatch_async(self.queue, ^{
            if (self.stopThisLater) {
                NSLog(@"任务将失败");
                // 手动创建错误,抛出去
                NSError *error = [NSError errorWithDomain:@"www.quantgroup.common" code:-1001 userInfo:@{NSLocalizedDescriptionKey:@"任务取消"}];
                QGNetWorkResponse *response = [QGNetWorkResponse failureResponseWith:nil error:error];
                if (result) {result(response,&self->_stopThisLater);}
                return ;
            }
            NSParameterAssert([className isKindOfClass:[NSString class]]);
            Class networkClass = NSClassFromString(className);
            if (!networkClass || ![networkClass respondsToSelector:@selector(shareManager)]) return ;
            QGBaseNetwork * netWorking = [networkClass performSelector:@selector(shareManager)];
            
            // 最终请求参数，包含：本次已知参数和上次请求的未知参数
            NSMutableDictionary *paramter = [NSMutableDictionary dictionaryWithDictionary:knowParam];
            if (self.unknowParam) {
                [paramter addEntriesFromDictionary:self.unknowParam];
            }
            
            if ([method isEqualToString:BASE_OPT_POST]) {
                [netWorking POST:url parameters:paramter success:^(id  _Nonnull responseObject) {
                    QGNetWorkResponse *response = [QGNetWorkResponse successResponseWith:responseObject];
                    // 执行Block,并获取下次请求的参数
                    if (result) {self.unknowParam = result(response,&self->_stopThisLater);}else{self.unknowParam = nil;}
                    dispatch_semaphore_signal(self.semaphore);  // 请求完成释放信号量，继续执行，放行任务
                } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
                    QGNetWorkResponse *response = [QGNetWorkResponse failureResponseWith:task error:error];
                    if (result) {self.unknowParam = result(response,&self->_stopThisLater);}else{self.unknowParam = nil;}
                    dispatch_semaphore_signal(self.semaphore);
                }];
            }else if ([method isEqualToString:BASE_OPT_GET]){
                [netWorking GET:url parameters:paramter success:^(id  _Nonnull responseObject) {
                    QGNetWorkResponse *response = [QGNetWorkResponse successResponseWith:responseObject];
                    if (result) {self.unknowParam = result(response,&self->_stopThisLater);}else{self.unknowParam = nil;}
                    dispatch_semaphore_signal(self.semaphore);
                } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
                    QGNetWorkResponse *response = [QGNetWorkResponse failureResponseWith:task error:error];
                    if (result) {self.unknowParam = result(response,&self->_stopThisLater);}else{self.unknowParam = nil;}
                    dispatch_semaphore_signal(self.semaphore);
                }];
            }else{
                NSError *error = [[NSError alloc]init];
                QGNetWorkResponse *response = [QGNetWorkResponse failureResponseWith:nil error:error];
                if (result) {self.unknowParam = result(response,&self->_stopThisLater);}else{self.unknowParam = nil;}
                dispatch_semaphore_signal(self.semaphore);
                NSLog(@"[App] ------       尚未支持这种请求......");
            }
            // 阻塞当前线程,直到本次请求完成,
           dispatch_semaphore_wait(self.semaphore, DISPATCH_TIME_FOREVER);
        });
        return self;
    };
}

- (QGDependChainManager * (^)(NSString *url,NSDictionary *knowParam, ChainRequestResultBlock result))mainGetThen
{
    return ^(NSString *url,NSDictionary *knowParam, ChainRequestResultBlock result){
         return self.then(NSStringFromClass([QGTalosNetwork class]),BASE_OPT_GET,url,knowParam,result);
    };
}

- (QGDependChainManager * (^)(NSString *url,NSDictionary *knowParam, ChainRequestResultBlock result))mainPostThen
{
    return ^(NSString *url,NSDictionary *knowParam, ChainRequestResultBlock result){
        return self.then(NSStringFromClass([QGTalosNetwork class]),BASE_OPT_POST,url,knowParam,result);
    };
}


- (void)cancleAllRequests
{
    
}

- (void)dealloc
{
    NSLog(@"QGDependChainManager Delloc")
}


@end
