//
//  QGChainManager.h
//  VirtualPayment
//
//  Created by silicn on 2019/8/2.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "QGBaseNetwork.h"
#import "QGNetWorkResponse.h"


NS_ASSUME_NONNULL_BEGIN


/**
 
 For example:
 
         self.manager = [QGDependChainManager manager];
 
         self.manager
         .mainGetThen(@"url", parameters, ^NSDictionary * _Nullable(QGNetWorkResponse * _Nonnull response, BOOL * _Nonnull stopThisLater) {
                 NSString *userId = response.responseObj[@"userId"];
                 // 返回url1请求所需要的参数
                 return @{@"userId":userId};
         })
         .mainGetThen(@"url1", parameters, ^NSDictionary * _Nullable(QGNetWorkResponse * _Nonnull response, BOOL * _Nonnull stopThisLater) {
                 // url2 这个请求将不会执行
                 *stopThisLater = YES;
                 return nil;
         })
         .mainGetThen(@"url2", parameters, ^NSDictionary * _Nullable(QGNetWorkResponse * _Nonnull response, BOOL * _Nonnull stopThisLater) {
                 return nil;
         });
 
 */



/**
 本次请求的响应结果，以及下次请求的所需要的依赖参数

 @param response 本次请求的响应结果
 @param stopThisLater  在此之后是否停止以后的Request
 @return 返回值：NSDictionary 就是下次请求所需要的参数unknowParam
 */
typedef NSDictionary * _Nullable (^ChainRequestResultBlock)(QGNetWorkResponse * response, BOOL *stopThisLater);

@interface QGDependChainManager : NSObject


/**
 便利构造器方法 ：非单例
 */
+ (instancetype)manager;


/**
 基础构造:then
 then:下一个网络请求
 
 @param className  请求类名 QGTalosNetwork 等
 @param method     GET | POST
 @param url        path | URL
 @param knowParam  已确定的本次请求需要的参数paramters
 @param result     ChainRequestResultBlock
 
 @discuss ChainRequestResultBlock 类型的返回值是一个字典NSDictionary. 也是下次请求的未知参数unknowParam
          knowParam 和 ChainRequestResultBlock返回值 共同组成了下次Request的Paramters
 */
@property (nonatomic, copy,readonly) QGDependChainManager *(^then)(NSString *className,NSString *method,NSString *url,NSDictionary *knowParam,ChainRequestResultBlock result);


/**
 便利构造L：mainGetThen
 mainGetThen:下一个网络请求
 
 @param className  请求类名：QGTalosNetwork
 @param method     固定：GET
 @param url        path | URL
 @param knowParam  已确定的本次请求需要的参数paramters
 @param result     ChainRequestResultBlock
 
 @discuss ChainRequestResultBlock 类型的返回值是一个字典NSDictionary. 也是下次请求的未知参数unknowParam
 knowParam 和 ChainRequestResultBlock返回值 共同组成了下次Request的Paramters
 */
@property (nonatomic, copy,readonly) QGDependChainManager *(^mainGetThen)(NSString *url,NSDictionary *knowParam,ChainRequestResultBlock result);


/**
 便利构造：mainPostThen
 mainPostThen:下一个网络请求
 
 @param className  请求类名 QGTalosNetwork
 @param method     POST
 @param url        path | URL
 @param knowParam  已确定的本次请求需要的参数paramters
 @param result     ChainRequestResultBlock
 
 @discuss ChainRequestResultBlock 类型的返回值是一个字典NSDictionary. 也是下次请求的未知参数unknowParam
 knowParam 和 ChainRequestResultBlock返回值 共同组成了下次Request的Paramters
 */
@property (nonatomic, copy,readonly) QGDependChainManager *(^mainPostThen)(NSString *url,NSDictionary *knowParam,ChainRequestResultBlock result);



@end

NS_ASSUME_NONNULL_END
