//
//  QGBatchRequestOperation.m
//  VirtualPayment
//
//  Created by 张博 on 2019/5/23.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGBatchRequestOperation.h"
#import "NSString+CreditWallet.h"

@interface QGBatchRequestOperation ()

@property (nonatomic, strong, readwrite, nullable) NSURLSessionTask *task;

@end


@implementation QGBatchRequestOperation

+ (instancetype)GET:(NSString *)urlString networkClassName:(NSString *)networkClassName parameters:(NSDictionary *)parameters success:(BaseRequestSuccessBlock)success failure:(BaseRequestFailureBlock)failure
{
    return [self privateRequestWithUrlString:urlString networkClassName:networkClassName opt:BASE_OPT_GET parameters:parameters success:success failure:failure];
}

+ (instancetype)POST:(NSString *)urlString networkClassName:(NSString *)networkClassName parameters:(NSDictionary *)parameters success:(BaseRequestSuccessBlock)success failure:(BaseRequestFailureBlock)failure
{
    return [self privateRequestWithUrlString:urlString networkClassName:networkClassName opt:BASE_OPT_POST parameters:parameters success:success failure:failure];
}


+ (instancetype)privateRequestWithUrlString:(NSString *)urlString networkClassName:(NSString *)networkClassName opt:(NSString *)opt parameters:(NSDictionary *)parameters success:(BaseRequestSuccessBlock)success failure:(BaseRequestFailureBlock)failure
{
    //空判断
    if ([NSString isEmpty:networkClassName] || ![networkClassName isKindOfClass:[NSString class]]) {
        return nil;
    }
    
    //获取请求类
    Class networkClass = NSClassFromString(networkClassName);
    //该类需要能够响应初始化方法
    if (![networkClass respondsToSelector:@selector(shareManager)]) {
        return nil;
    }
    QGBaseNetwork * network = [networkClass performSelector:@selector(shareManager)];
    if (!network) {
        return nil;
    }
    
    QGBatchRequestOperation * operation = [[QGBatchRequestOperation alloc]init];
    NSURLSessionDataTask * task =  [network AFTaskWithUrlString:urlString opt:opt parameters:parameters success:^(id  _Nonnull responseObject) {
        if (success) {
            success(responseObject);
        }
        [operation completeOperation];
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        if (failure) {
            failure(task,error);
        }
        [operation completeOperation];
    }];
    operation.task = task;
    return operation;
}

- (void)main {
    [self.task resume];
}

- (void)completeOperation {
    self.task = nil;
    [super completeOperation];
   
    
}

- (void)cancel {
    [self.task cancel];
    [super cancel];
}


- (void)dealloc
{
//    NSLog(@"______dealloc");
}
@end
