//
//  QGBatchOperationManager.m
//  VirtualPayment
//
//  Created by silicn on 2019/5/23.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGBatchOperationManager.h"
#import "AFHTTPSessionManager.h"

#import "QGBatchManageAgent.h"



@interface QGBatchOperationManager ()

@property (nonatomic, strong)NSOperationQueue *operationQueue;

@property (nonatomic, copy,readwrite)NSMutableArray<QGBatchRequestOperation *> *operations;


@end

@implementation QGBatchOperationManager


- (instancetype)initWithSerial:(BOOL)isSerial
{
    self = [super init];
    if (self) {
        self.operationQueue = [[NSOperationQueue alloc]init];
        self.operationQueue.maxConcurrentOperationCount = -1;
        [self.operationQueue addObserver:self forKeyPath:@"operations" options:NSKeyValueObservingOptionNew context:nil];
        if (isSerial) {
             self.operationQueue.maxConcurrentOperationCount = 1;
        }
        
        [[QGBatchManageAgent shareAgent] addOperationManager:self];
    }
    return self;
}

- (instancetype)init{
    return [self initWithSerial:NO];
}


- (void)observeValueForKeyPath:(NSString *)keyPath ofObject:(id)object change:(NSDictionary<NSKeyValueChangeKey,id> *)change context:(void *)context
{
    if (object != self.operationQueue || ![keyPath isEqualToString:@"operations"]) {
        return;
    }
    if (self.operationQueue.operations.count == 0) {
        if (self.allOperationCompleteBlock) self.allOperationCompleteBlock(YES);
        [[QGBatchManageAgent shareAgent] removeOperationManger:self];
    }
}

- (void)addRequestOperation:(QGBatchRequestOperation *)operation
{
    [self.operationQueue addOperation:operation];
}

- (void)GET:(NSString *)urlString networkClassName:(NSString *)networkClassName parameters:(NSDictionary *)parameters success:(BaseRequestSuccessBlock)success failure:(BaseRequestFailureBlock)failure
{
    QGBatchRequestOperation *operation = [QGBatchRequestOperation GET:urlString networkClassName:networkClassName parameters:parameters success:success failure:failure];
    NSAssert(operation != nil, @"QGBatchRequestOperation: opertion is nil ");
    
    if (operation) {
         [self.operationQueue addOperation:operation];
    }else{
        NSLog(@"[Request] QGBatchRequestOperation: opertion is nil ")
    }
}

- (void)POST:(NSString *)urlString networkClassName:(NSString *)networkClassName parameters:(NSDictionary *)parameters success:(BaseRequestSuccessBlock)success failure:(BaseRequestFailureBlock)failure
{
    QGBatchRequestOperation *operation = [QGBatchRequestOperation POST:urlString networkClassName:networkClassName parameters:parameters success:success failure:failure];
     NSAssert(operation != nil, @"QGBatchRequestOperation: opertion is nil ");
   
    if (operation) {
        [self.operationQueue addOperation:operation];
    }else{
        NSLog(@"[Request] QGBatchRequestOperation: opertion is nil ");
    }
}


- (void)dealloc
{
    [self.operationQueue removeObserver:self forKeyPath:@"operations"];
    NSLog(@"_______dealloc");
}




//- (instancetype)initWithRequestManager:(AFHTTPSessionManager *)manager
//{
//    self = []
//}

@end
