//
//  QGBatchOperationManager.h
//  VirtualPayment
//
//  Created by silicn on 2019/5/23.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import <Foundation/Foundation.h>

#import "QGBatchRequestOperation.h"


typedef void(^BatchOperationCompleteBlock)(BOOL allSuccess);



@interface QGBatchOperationManager : NSObject


/**
 建议初始化方法
 如果使用init方法，默认isSerial:NO

 @param isSerial YES:串行  NO:并发
 @return QGBatchOperationManager
 */
- (instancetype)initWithSerial:(BOOL)isSerial;

@property (nonatomic, copy,readonly)NSArray<QGBatchRequestOperation *> *operations;

/// 所有的Operation完成回调，但是不保证所有的request请求成功
@property (nonatomic, copy)BatchOperationCompleteBlock allOperationCompleteBlock;

/**
 依赖关系网络请求 GET
 
 @param urlString 拼接的URL
 @param networkClassName 继承于BaseNetWork的类名
 @param parameters body参数
 @param success 成功回调
 @param failure 失败回调
 */
- (void)GET:(NSString *)urlString networkClassName:(NSString *)networkClassName parameters:(NSDictionary *)parameters success:(BaseRequestSuccessBlock)success failure:(BaseRequestFailureBlock)failure;

/**
 依赖关系网络请求 POST
 
 @param urlString 拼接的URL
 @param networkClassName 继承于BaseNetWork的类名
 @param parameters body参数
 @param success 成功回调
 @param failure 失败回调
 */
- (void)POST:(NSString *)urlString networkClassName:(NSString *)networkClassName parameters:(NSDictionary *)parameters success:(BaseRequestSuccessBlock)success failure:(BaseRequestFailureBlock)failure;



@end


