//
//  QGBatchManageAgent.m
//  VirtualPayment
//
//  Created by silicn on 2019/5/24.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGBatchManageAgent.h"

@interface QGBatchManageAgent()

@property (nonatomic, strong)NSMutableArray *managers;


@end

@implementation QGBatchManageAgent

+ (instancetype)shareAgent
{
    static QGBatchManageAgent *manager = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        manager = [[self alloc] init];
    });
    return manager;
}

- (void)addOperationManager:(QGBatchOperationManager *)manager
{
    [self.managers addObject:manager];
}

- (void)removeOperationManger:(QGBatchOperationManager *)manager
{
    [self.managers removeObject:manager];
}

- (NSMutableArray *)managers
{
    if (!_managers) {
        _managers = [NSMutableArray array];
    }
    return _managers;
}


@end
