
//  QGRequestCenter.m
//  QuantGroup
//
//  Created by SongWentong on 15/1/29.
//  Copyright (c) 2015年 QuantGroup. All rights reserved.
//

#import "QGRequestCenter.h"
#import <CoreLocation/CoreLocation.h>

#import "UIImage+CreditWallet.h"
#import "SystemManager.h"
#import "QGUserInfo.h"
#import "NSString+CreditWallet.h"
#import "QGAppMacro.h"
static NSString *const FORM_FLE_INPUT = @"file";
static NSString *const APP_ID = @"0002";
static NSString *const APP_KEY = @"lkb010203#$%";

@implementation QGRequestCenter
+ (NSString *)baseURL {
    //线上环境
    return AppBackendBaseUrl;
}

///雪飞
+ (NSString *)baseURLOLD {
    return @"https://openapi.quantgroup.cn"; //正式环境old
    //    return @"http://192.168.11.11:80";//正式环境old
}
// 数据部host 杨大伟
+ (NSString *)baseURLForDepartmentOfData {
    return @"https://log.quantgroup.cn"; //正式环境old
}
/**
 mock baseUrl
 
 @return mock baseUrl
 */
+ (NSString *)mockBaseUrl {
    return @"http://192.168.4.248/mockjsdata/122";
}

/**
 用户行为数据采集 王铮
 
 @return 地址
 */
+ (NSString *)userBehaviorDataAcquisitionBaseUrl {
    //线上地址
    return @"https://collect.quantgroup.cn";
    //测试地址
    //    return @"http://192.168.4.28:7055";
    //    return @"http://192.168.4.50:7055";
    //薛智杰
    //    return @"http://192.168.28.69:7055";
}

+ (NSString *)urlWithQGRequestServerMethod:(QGRequestServerMethod)method {
    if (method < QGRequestServerMethodPhoneTag) {
        return [self newUrlWithIndex:method];
    } else {
        return [self oldUrlWithIndex:method];
    }

    //    return [self urlWithIndex:method];
}

/*!
 接口URL
 */
+ (NSString *)urlWithIndex:(QGRequestServerMethod)index {
    return [self urlWithQGRequestServerMethod:index];
}

/**
 *  QGRequestServerMethodPhoneTag 之后的接口
 *
 *  @param index 索引
 *
 *  @return 接口
 */
+ (NSString *)oldUrlWithIndex:(NSInteger)index {

    index = index - QGRequestServerMethodPhoneTag - 1;

    NSMutableArray *urls = [[NSMutableArray alloc] init];
    [urls addObject:@"LKBClient/openapi/resetpwdForm.json"];          //8.修改密码
    [urls addObject:@"LKBClient/openapi/main/loans/fromDetail.json"]; //9.查看物流详情
    [urls addObject:@"LKBClient/main/loans/saveCheckedOrg.json"];     //10.保存选择的金融机构
    [urls addObject:@"LKBClient/feedback/save.json"];                 //11.提交问题反馈
    [urls addObject:@"LKBClient/main/loans/saveLoanInfo.json"];       //12.保存个人信息
    [urls addObject:@"data-auth/openapi/app/push/contact-list.json"]; //13.上传通讯录
    [urls addObject:@"log/pv.gif"];                                   //14.上传地理位置
    [urls addObject:@"LKBClient/openapi/push/messageCenter.json"];    //15.消息中心
    [urls addObject:@"LKBClient/openapi/getPart.json"];               //16.获取当前百分比
    [urls addObject:@"LKBClient/openapi/xuexin/sendSms.json"];        //17.学信网发送短信
    [urls addObject:@"LKBClient/aboutus.jsp"];                        //18.关于我们
    [urls addObject:@"LKBClient/share.jsp"];                          //19.分享页面
    NSString *interfaceName = urls[index];
    NSString *result = [NSString stringWithFormat:@"%@/%@", [self baseURLOLD], interfaceName];
    return result;
}

/**
 *  QGRequestServerMethodPhoneTag 之前的接口
 *
 *  @param index 索引
 *
 *  @return 接口
 */
+ (NSString *)newUrlWithIndex:(NSInteger)index {
    NSMutableArray *urls = [[NSMutableArray alloc] init];
    [urls addObject:@"interface0"];
    [urls addObject:@"LKBClient/loan/getLoanInfo.json"];          //1.获取贷款信息
    [urls addObject:@"auth/login/v1"];                            //2.登录
    [urls addObject:@"LKBClient/openapi/register/checkSms.json"]; //3.检验短信验证码
    [urls addObject:@"api/captchas/v2"];                          //4.发送短信
    [urls addObject:@"auth/existing"];                            //5.检验手机号是否已经注册
    [urls addObject:@"api/users"];                                //6.修改密码
    [urls addObject:@"auth/register"];                            //7.注册
    [urls addObject:@"api/jpush/submit-id"];                      //8.上传RegistrationID
    [urls addObject:@"api/config/banners"];                       //9.欢饮页图片
    [urls addObject:@"api/sharing"];                              //10获取分享的内容
    [urls addObject:@"api/users"];                                //QGRequestServerMethodCreditSource信用管理：
    [urls addObject:@"api/loan-questions"];                       //12.常见问题
    [urls addObject:@"api/broad"];                                //13活动接口

    [urls addObject:@"api/authorization/zhengxin/register/init"];                  //14征信获取个人信息
    [urls addObject:@"api/authorization/zhengxin/register/step-first"];            //15征信上传个人信息
    [urls addObject:@"api/authorization/zhengxin/query-code/init"];                //16征信获取个人信息图片验证码
    [urls addObject:@"api/authorization/zhengxin/register/send-msg"];              //17征信获取个人信息图片验证码
    [urls addObject:@"api/authorization/zhengxin/register/check-registered-name"]; //18征信检查用户名：
    [urls addObject:@"api/authorization/zhengxin/register/step-second"];           //19征信注册：
    [urls addObject:@"api/authorization/zhengxin/query-code/verify-login"];        //20征信登录：
    [urls addObject:@"api/authorization/zhengxin/query-code/choose-certify"];      //21征信问题：

    [urls addObject:@"api/blank-note"];                                   //22获取白条状态：
    [urls addObject:@"api/mall/phone-recharge/products"];                 //23 获取手机充值产品列表
    [urls addObject:@"api/mall/phone-recharge/order"];                    //24手机充值下单
    [urls addObject:@"api/mall/order-list/v2"];                           //25查询我的订单
    [urls addObject:@"api/authorization/zhengxin/query-code/submit-kba"]; //26分享页面
    [urls addObject:@"api/mall/phone-recharge/re-order"];                 //27继续支付订单
    [urls addObject:@"api/banners?place = BlankNote_Top"];                //28 白条页面 banner
    [urls addObject:@"public/agreements/index.html"];                     //29.用户使用协议
    [urls addObject:@"api/blank-note/query-status"];                      //30 获取白条状态 （新接口）
    [urls addObject:@"api/loan/list"];                                    //31 获取历史借款记录(无需token和newToken)
    [urls addObject:@"api/mall/phone-recharge/setting"];                  //32获取话费充值永不停机设置
    [urls addObject:@"api/blank-note/verify-password"];                   //33获取话费充值永不停机设置
    [urls addObject:@"api/mall/phone-flow-top-up/products"];              //34 获取手机充值产品列表
    [urls addObject:@"api/mall/phone/reorder"];                           //35.继续支付订单(话费、流量充值)
    [urls addObject:@"api/mall/phone-flow-top-up/order"];                 //36.手机充流量下单

    //水电煤
    [urls addObject:@"api/mall/utility-recharge/cities"];       //37.获取城市列表
    [urls addObject:@"api/mall/utility-recharge/types"];        //38.获取缴费类别列表
    [urls addObject:@"api/mall/utility-recharge/corporations"]; //39.获取缴费单位列表
    [urls addObject:@"api/mall/utility-recharge/products"];     //40.获取缴费商品列表
    [urls addObject:@"api/mall/utility-recharge/balances"];     //41.查询欠费
    [urls addObject:@"api/mall/utility-recharge/pay"];          //42水电煤缴费
    [urls addObject:@"api/mall/utility-recharge/orders"];       //43获取生活缴费记录
    [urls addObject:@"auth/fast-login"];                        //44快捷登录
    [urls addObject:@"api/config/user"];                        //45获取用户配置
    [urls addObject:@"api/loan/loan-url"];                      //46获取贷款状态
    [urls addObject:@"api/config/widgets"];                     //47获取 widgets(浮窗、弹窗)
    [urls addObject:@"api/idfa"];                               //48上传IDFA
    [urls addObject:@"api/activities"];                         //49获取活动中心所有活动
    [urls addObject:@"api/mall/game-recharge/games"];           //50游戏列表
    [urls addObject:@"api/mall/game-recharge/direct-fill"];     //51游戏直充接口
    [urls addObject:@"auth/refresh-token"];                     //52 刷新Token  旧的 auth/get-token
    [urls addObject:@"api/mall/3c/groups"];                     //53 3C 商品列表接口
    [urls addObject:@"api/mall/3c/orders"];                     //54 3C 订单详情
    [urls addObject:@"api/mall/3c/products"];                   //55 3C 商品详情
    [urls addObject:@"api/mall/3c/product-query"];              //56 3C商品查询
    [urls addObject:@"api/mall/3c/search/products"];            //57 关键字查询商品
    [urls addObject:@"api/mall/3c/search/word/v2"];             //58 关键字查询商品名称
    [urls addObject:@"order/make/v5.8"];                        //59 下单购买
    //[urls addObject:@"api/mall/3c/brands"];                    // 3C品牌
    [urls addObject:@"api/mall/3c/product/brand/v2"];   // 3C品牌
    [urls addObject:@"api/mall/3c/filter"];             // 3C根据搜索条件过滤
    [urls addObject:@"api/mall/fuel-recharge/groups"];  //60 加油卡列表
    [urls addObject:@"api/mall/fuel-recharge/pay"];     //61 加油卡直充接口
    [urls addObject:@"api/authorization/mobile/url"];   //62 获取H5手机运营商授权页面地址
    [urls addObject:@"api/authorization/mark"];         //63 认证成功通知接口
    [urls addObject:@"api/mall/video/groups"];          //64 获取视频会员列表
    [urls addObject:@"api/mall/video/pay"];             //65 视频直冲
    [urls addObject:@"api/mall/video/banners"];         //66 视频banner
    [urls addObject:@"api/mall/education/cities"];      //66 教育分期城市列表接口
    [urls addObject:@"api/mall/education/courses"];     //67 课程详情
    [urls addObject:@"api/mall/education/pay"];         //68 下单购买教育分期
    [urls addObject:@"api/mall/education/orders"];      //69 教育分期订单详情
    [urls addObject:@"api/users/auth-center"];          //70 攒信用 授权中心
    [urls addObject:@"api/mall/hotel/cities"];          //71 酒店白条  获取城市列表
    [urls addObject:@"api/mall/hotel/hotels"];          //72 查询酒店
    [urls addObject:@"api/mall/hotel/pay"];             //73 酒店下单
    [urls addObject:@"api/mall/hotel/orders"];          //74 3C 订单详情
    [urls addObject:@"api/mall/phone/groups"];          //75 话费、流量产品列表
    [urls addObject:@"api/mall/phone/pay"];             //76 话费、流量下单    （单独的下单接口将会废弃）
    [urls addObject:@"api/mall/3c/category"];           //77 某类商品列表接口
    [urls addObject:@"api/mall/contact-address-query"]; //78 3c详情地址查询
    [urls addObject:@"api/mall/contact-address-save"];  //79 3c修改地址保存接口
    //    [urls addObject:@"api/tab/loan/home/v2"];                     //80 首页 借款tab接口
    [urls addObject:@"api/tab/loan/home/v3"];                     //80 首页 借款tab接口
    [urls addObject:@"api/tab/blanknote/home/v2"];                //81 白条tab接口
    [urls addObject:@"api/tab/blanknote/entries"];                //82 更多场景
    [urls addObject:@"api/tab/loan/submit-loan-demand"];          //83 提交贷款请求的信息
    [urls addObject:@"api/authorization/zhifubao/qrcode-url"];    //84获取支付宝二维码URL
    [urls addObject:@"api/authorization/zhifubao/qrcode-status"]; //85检查二维码登录状态

    //火车票
    [urls addObject:@"api/mall/train/stations"];                //86 车站列表
    [urls addObject:@"api/mall/train/search-by-stations"];      //87车站查询
    [urls addObject:@"api/mall/train/timetable"];               //88列车时刻表
    [urls addObject:@"api/mall/train/passengers"];              //89获取乘客列表
    [urls addObject:@"api/mall/train/add-passenger"];           //90添加乘客信息
    [urls addObject:@"api/mall/train/update-passenger"];        //91修改乘客信息
    [urls addObject:@"api/mall/train/pay"];                     //92火车票下单
    [urls addObject:@"api/mall/train/orders"];                  //93火车票订单详情
    [urls addObject:@"api/mall/train/help-page-url"];           //94获取片获取帮助页面
    [urls addObject:@"api/config/global"];                      //95获取全局配置
    [urls addObject:@"api/ads/url"];                            //96获取广告
    [urls addObject:@"api/ads/check"];                          //97检验是否显示广告
    [urls addObject:@"api/mall/train/grab/search-by-stations"]; //火车票-抢票-站站查询
    [urls addObject:@"api/mall/train/config"];                  //99火车票配置接口
    [urls addObject:@"api/mall/train/grab/cancel"];             //100 火车票抢票单
    [urls addObject:@"api/mall/train/grab/orders"];             //101 火车票抢票订单详情
    [urls addObject:@"api/mall/train/grab/pay"];                //102 提交抢票订单

    [urls addObject:@"api/mall/3c/address/user/v2"]; //103.更新收货地址

    //授权认证
    [urls addObject:@"api/authorization/zhima/url"];            //104.获取芝麻信用分认证h5页面URL
    [urls addObject:@"api/mall/game-recharge/games/spuDetail"]; //105.获取游戏充值模板
    [urls addObject:@"api/mall/game-recharge/createOrder"];     //106.游戏下单
    
    
    [urls addObject:@"api/captchas/new"];                        //107.获取新的图形验证码
    [urls addObject:@"api/tab/clife"];                           //108.获取信用首页
    [urls addObject:@"api/tab/flash"];                           //109.获取急速借款tab


    NSString *interfaceName = urls[index];
    NSString *result = [NSString stringWithFormat:@"%@/%@", [self baseURL], interfaceName];
    return result;
}
+ (NSDictionary *)additionalParas {
    NSMutableDictionary *dict = [NSMutableDictionary dictionary];
    NSDate *date = [NSDate date];
    NSString *timeuint = [NSString stringWithFormat:@"%.0f", date.timeIntervalSince1970 * 1000];
    //    时间戳
    [dict setValue:timeuint forKey:@"timeunit"];
    //    app id
    [dict setValue:APP_ID forKey:@"appId"];
    //    token
    NSString *token = [NSString stringWithFormat:@"timeunit=%@appkey=%@", timeuint, APP_KEY];
    [dict setValue:[token md5] forKey:@"token"];
    //    uid
    NSString *uuid = [QGUserInfo sharedUserInfo].uuid;
    if ([uuid length] > 0) {
        [dict setValue:uuid forKey:@"userId"];
    }
    return dict;
}



/**
 * 生成GUID
 */
+ (NSString *)generateUuidString {
    // create a new UUID which you own
    CFUUIDRef uuid = CFUUIDCreate(kCFAllocatorDefault);
    // create a new CFStringRef (toll-free bridged to NSString)
    // that you own
    NSString *uuidString = (NSString *) CFBridgingRelease(CFUUIDCreateString(kCFAllocatorDefault, uuid));
    // transfer ownership of the string
    // to the autorelease pool
    // release the UUID
    CFRelease(uuid);
    return uuidString;
}

#pragma mark - 延时的方法
void perform(dispatch_block_t block, NSTimeInterval delay) {
    [QGRequestCenter performBlock:block afterDelay:delay];
}

+ (void)performBlock:(dispatch_block_t)block afterDelay:(NSTimeInterval)delay {
    [self performBlock:block
               inQueue:dispatch_get_main_queue()
            afterDelay:delay];
}

+ (void)performBlock:(dispatch_block_t)block inQueue:(dispatch_queue_t)queue afterDelay:(NSTimeInterval)delay {
    dispatch_time_t t = dispatch_time(DISPATCH_TIME_NOW, delay * 1000 * 1000 * 1000);
    dispatch_after(t, queue, ^{
        if (block) {
            block();
        }
    });
}
//请求队列
static NSOperationQueue *sharedQueue = nil;
+ (NSOperationQueue *)sharedQueue {
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        sharedQueue = [[NSOperationQueue alloc] init];
        [sharedQueue setSuspended:NO];
        [sharedQueue setMaxConcurrentOperationCount:32];
        sharedQueue.name = @"WTRequestCentersharedQueue";
    });
    return sharedQueue;
}
#pragma mark - 辅助
+ (id)JSONObjectWithData:(NSData *)data {
    if (!data) {
        return nil;
    }
    //    容器解析成可变的，string解析成可变的，并且允许顶对象不是dict或者array
    NSJSONReadingOptions option = NSJSONReadingMutableContainers | NSJSONReadingMutableLeaves | NSJSONReadingAllowFragments;
    return [NSJSONSerialization JSONObjectWithData:data
                                           options:option
                                             error:nil];
}

+ (NSData *)dataFromJSONObject:(id)object {
    if ([NSJSONSerialization isValidJSONObject:object]) {
        NSData *data = [NSJSONSerialization dataWithJSONObject:object options:0 error:nil];
        return data;
    }
    return nil;
}
//这个方法用于类型不固定时候的一个过滤
//传入一个NSNumber，NSString或者NSNull类型的数据即可
+ (NSString *)stringWithData:(NSObject *)data {
    if ([data isEqual:[NSNull null]]) {
        return @"";
    }
    if ([data isKindOfClass:[NSString class]]) {
        return (NSString *) data;
    }
    if ([data isKindOfClass:[NSNumber class]]) {
        NSNumber *number = (NSNumber *) data;
        return [number stringValue];
    }
    return @"";
}

@end
