//
//  QGRequestCenter.h
//  QuantGroup
//
//  Created by SongWentong on 15/1/29.
//  Copyright (c) 2015年 QuantGroup. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "AFNetworking.h"
#import <UIKit/UIKit.h>
@class UIImage;
@interface QGRequestCenter : NSObject

//请求方法的枚举
typedef NS_ENUM(NSInteger, QGRequestServerMethod) {
    QGRequestServerMethodGetLoanInfo = 1,//1.获取贷款信息
    QGRequestServerMethodLogin,                 //2.登录
    QGRequestServerMethodLoginCheckSms,         //3.检验短信验证码
    QGRequestServerMethodRegisterSendSms,       //4.发送短信
    QGRequestServerMethodCheckLoginName,        //5.检验手机号是否已经注册
    QGRequestServerMethodModifyPWD,             //6.修改密码
    QGRequestServerMethodRegister,              //7.注册
    QGRequestServerMethodReportRegistrationID,          //8.上传RegistrationID
    QGRequestServerMethodGetBannerAndUrl,       //9.欢迎页图
    QGRequestServerMethodGetShareContent,       //10获取分享内容
    QGRequestServerMethodCreditSource,          //11
    QGRequestServerMethodFeedBackLookProblem,   //12.常见问题
    QGRequestServerMethodBroad,                 //13活动接口

    QGRequestServerMethodZhengXinInit,          //14 征信初始化验证码
    QGRequestServerMethodZhengXinFirst,         //15征信上传个人信息
    QGRequestServerMethodZhengXinQueryCodeInit, //16征信获取个人信息图片验证码
    QGRequestServerMethodZhengXinregisterMsg,   //17 征信注册短信
    QGRequestServerMethodZhengXinCheckName,     //18检查征信名称是否被占用
    QGRequestServerMethodZhengXinRegister,      //19征信注册
    QGRequestServerMethodZhengXinLogin,         //20征信登录
    QGRequestServerMethodZhengXinChooseCerfity, //21验证征信问题

    QGRequestServerMethodWhiteBarStatus,        //22白条
    QGRequestServerMethodPhoneRechareList,      //23 获取手机充值产品列表
    QGRequestServerMethodPhoneOrder,            //24手机充值下单
    QGRequestServerMethodCheckPhoneOrder,       //25查询我的订单
    QGRequestServerMethodSubmitZhengXinCode,    //26提交征信问题答案
    QGRequestServerMethodContinuePay,           //27
    QGRequestServerMethodGetIOUBannerAndUrl,    //28白条页面 banner
    QGRequestServerMethodUserAgreement,         //29.用户使用协议
    QGRequestServerMethodQueryIOUStatusNew,     //30获取白条状态新接口
    QGRequestServerMethodQueryLoanHistory,      //31获取历史借款记录
    QGRequestServerMethodQueryPhoneRechargeSetting,//32获取话费充值永不停机设置
    QGRequestServerMethodVerIOUPWD,             //33获取话费充值永不停机设置
    QGRequestServerMethodPhoneTrafficList,      //34 获取手机充值产品列表
    QGRequestServerMethodContinuePhoneTrafficOrder, //35.继续支付订单(话费、流量充值)
    QGRequestServerMethodTrafficOrder,          //36.手机充流量下单

    //水电煤
    QGRequestServerMethodChargeUtilityCities,   //37.获取城市列表
    QGRequestServerMethodChargeUtilityTypes,    //38.获取缴费类别列表
    QGRequestServerMethodChargeUtilityCorporation,//39.获取缴费单位列表
    QGRequestServerMethodChargeUtilityProducts, //40.获取缴费商品列表
    QGRequestServerMethodUtilityRechargeBalances,//41.查询欠费
    QGRequestServerMethodUtilityRechargePay,    //42.水电煤缴费
    QGRequestServerMethodUtilityRechargeOrders, //43.获取生活缴费记录
    QGRequestServerMethodFastLogin,             //44快捷登录
    QGRequestServerMethodConfigUser,            //45获取用户配置
    QGRequestServerMethodGetLoanUrl,            //46获取贷款状态
    QGRequestServerMethodWidgets,               //47 获取 widgets(浮窗、弹窗)
    QGRequestServerMethodUploadIDFA,            //48上传IDFA
    QGRequestServerMethodactivities,            //49获取活动中心所有活动
    QGRequestServerMethodGameRecharge,          //50 获取游戏列表
    QGRequestServerMethodDirectFill,            //51 游戏直充接口
    QGRequestServerMethodAuthGetToken,          //52刷新token
    QGRequestServerMethod3cgroups,              //53 3C 商品列表接口
    QGRequestServerMethod3cOrdersDetails,       //54 3C 订单详情
    QGRequestServerMethod3cProducts,            //55 3C 商品详情
    QGRequestServerMethod3cProductQuery,        //56 3C商品查询
    QGRequestServerMethod3cSearchProducts,       //57 关键字查询商品
    QGRequestServerMethod3cSearchWord,          //58 关键字查询商品名称
    QGRequestServerMethod3cPay,                 //59 下单购买3c
    QGRequestServerMethod3cBrands,              //59.2 3C用于筛选的品牌
    QGRequestServerMethod3cFilter,              //59.3 3C根据搜索条件过滤
    
    QGRequestServerMethodFuelRechargeGroups,    // 60 加油卡列表
    QGRequestServerMethodFuelRechargePay,       //61 加油卡直充接口
    QGRequestServerMethodMobileH5,              //62 获取H5手机运营商授权页面地址
    QGRequestServerMethodMark,                  //63 认证成功通知接口
    QGRequestServerMethodVideoGroups,           //64 获取视频会员列表
    QGRequestServerMethodVideoPay,              //65 视频直冲
    QGRequestServerMethodVideoBanners,         //66 视频banner
    QGRequestServerMethodEducationsCities,      //66.获取城市列表
    QGRequestServerMethodapiEducationCourses,   //67课程详情
    QGRequestServerMethodEducationPay,          //68 下单购买
    QGRequestServerMethodEducationOrders,       //69 教育分期订单详情
    QGRequestServerMethodUsersAuthCenter,       //70 攒信用 授权中心
    QGRequestServerMethodHotelCities,           //71 酒店白条  获取城市列表
    QGRequestServerMethodQueryHotels,           //72 查询酒店
    QGRequestServerMethodHotelPay,              //73酒店下单
    QGRequestServerMethodHotelOrdersDetails,    //74 3C 订单详情
    QGRequestServerMethodPhoneGroups,            //75 话费、流量产品列表 （单独的列表将会废弃）
    QGRequestServerMethodPhonePay,               //76 话费、流量下单    （单独的下单接口将会废弃）
    QGRequestServerMethod3CCategory,             //77 某类商品列表接口
    QGRequestServerMethodContactAddressQuery,     //78 3c详情地址信息
    QGRequestServerMethodContactAddressSave,      //79 3c修改地址保存接口
    QGRequestServerMethodTab_Loan_Home,          //80 首页 借款tab接口
    QGRequestServerMethodTabBlanknoteHomeV2,       //81 白条tab接口
    QGRequestServerMethodBlanknoteEntries,       //82 更多场景
    QGRequestServerMethodSubmitLoanDemand,       //83 提交贷款请求的信息
    QGRequestServerMethodZhiFuBaoQrcodeUrl,      //84获取支付宝二维码URL
    QGRequestServerMethodZhiFuBaoQrcodeStatus,   //85检查二维码登录状态
    
    //火车票
    QGRequestServerMethodTrainStations,          //86车站列表
    QGRequestServerMethodTrainSearch,            //87车站查询
    QGRequestServerMethodTrainTimetable,         //88列车时刻表
    QGRequestServerMethodTrainPassengers,        //89获取乘客列表
    QGRequestServerMethodTrainAddPassengers,     //90添加乘客信息
    QGRequestServerMethodTrainUpdatePassengers,  //91修改乘客信息
    QGRequestServerMethodTrainPay,               //92火车票下单
    QGRequestServerMethodTrainOrders,            //93火车票订单详情
    QGRequestServerMethodTrainhelpPageUrl,       //94获取片获取帮助页面
    QGRequestServerMethodConfigGlobal,           //95获取全局配置
    QGRequestServerMethodAdsUrl,                 //96获取广告
    QGRequestServerMethodAdsCheck,               //97检验是否显示广告
    QGRequestServerMethodQPQueryTrainNumber,     //98抢票 - 站站查询
    QGRequestServerMethodTrainConfig,            //99火车票配置接口
    QGRequestServerMethodTrainGrabCancel,        //100 火车票抢票单
     QGRequestServerMethodTrainGrabOrders,       //101 火车票抢票订单详情
    QGRequestServerMethodTrainGrabPay,           //102 提交抢票订单
    QGRequestServerMethod3cAddress,              //103.更新收货地址
    
    //授权认证
    QGRequestServerMethodGetAuthZhiMaFenURL,    //104.获取芝麻信用分认证h5页面URL
    QGRequestServerMethodGetGameTemplate,       //105.获取游戏充值模板
    QGRequestServerMethodGameCreateOrder,       //106.游戏下单
    
    QGRequestServerMethodAPICaptchaNew,         //107.获取新的图形验证码
    QGRequestServerMethodAPITabCreditLife,      //108.获取生活
    QGRequestServerMethodAPITabHotActivity,      //109.获取极速借款tab

    
    /**
     *  ------------------------------
     */
    QGRequestServerMethodPhoneTag,              //_______万能的分隔符
    /**
     *  -----------下面的，j-------------------
     */
    
    
    
    
    QGRequestServerMethodResetPWDForm,          //8.修改密码
    QGRequestServerMethodFromDetail,            //9.查看物流详情
    QGRequestServerMethodSaveCheckedOrg,        //10.保存选择的金融机构
    QGRequestServerMethodSave,                  //11.提交问题反馈
    QGRequestServerMethodSaveLoanInfo,          //12.保存个人信息
    QGRequestServerMethodPushContact,           //13.上传通讯录
    QGRequestServerMethodPushContactLocation,   //14.上传地理位置
    QGRequestServerMethodMessageCenter,         //15.消息中心
    QGRequestServerMethodGetPart,               //16.获取当前百分比
    QGRequestServerMethodXueXinSendSms,         //17.学信网发送短信
    QGRequestServerMethodAboutus,               //18.关于我们
    QGRequestServerMethodShare,                 //19.分享
};
/*!
    根URL
 */
+(NSString*)baseURL;

/*!
 根URL
 */
+(NSString*)baseURLOLD;

// 数据部host
+(NSString *)baseURLForDepartmentOfData;
/**
 mock 跟地址
 
 @return 返回跟地址
 */
+ (NSString *)mockBaseUrl;

/**
 用户行为数据采集 王铮
 
 @return 地址
 */
+ (NSString *)userBehaviorDataAcquisitionBaseUrl;


/*!
    根据接口名返回URL
 */
+(NSString*)urlWithQGRequestServerMethod:(QGRequestServerMethod)method;

/*!
    接口URL
 */
+(NSString*)urlWithIndex:(QGRequestServerMethod)index;


/**
 *  添加爬虫授权
 *
 *  @return Paras
 */
+(NSDictionary*)additionalParas;


/**
 * 生成GUID
 */
+ (NSString *)generateUuidString;

#pragma mark - 延时的方法
/*!
 在daley秒后执行一个block
 */
void perform(dispatch_block_t block , NSTimeInterval delay);
/*!
 在daley秒后执行一个block
 */
+(void)performBlock:(dispatch_block_t)block
         afterDelay:(NSTimeInterval)delay;
/*!
 在daley秒后执行一个block
 */
+(void)performBlock:(dispatch_block_t)block
            inQueue:(dispatch_queue_t)queue
         afterDelay:(NSTimeInterval)delay;
/*!
 shared Call Back Queue
 */
+(NSOperationQueue*)sharedQueue;

#pragma mark - 辅助
// convert json data to object
+(id)JSONObjectWithData:(NSData*)data;
+(NSString*)stringWithData:(NSObject*)data;

// convert object to json data
+(NSData*)dataFromJSONObject:(id)object;

@end
