//
//  QGNetWork.h
//  QGNetWork
//
//  Created by 银恭敬 on 1/15/16.
//  Copyright © 2016 cbs. All rights reserved.
//

#import "AFNetworking.h"
#define OPT_GET @"GET"
#define OPT_POST @"POST"
#define OPT_PUT @"PUT"
//请求成功回调block
typedef void (^requestSuccessBlock)(id responseObject);
//带有businessCode请求成功回调block
typedef void (^businessCodeRequestSuccessBlock)(NSString *businessCode, NSString *code, id responseObject);
//请求失败回调block
typedef void (^requestFailureBlock)(id responseObject);

//请求参数编码方式
typedef enum : NSUInteger {
    QGNetWorkRequestSerializerNone, //默认的方式，兼容旧函数
    QGNetWorkRequestSerializerHttp, //普通的http的编码格式
    QGNetWorkRequestSerializerJson, //json编码格式的  与APPbackend的交互首选方案、如果需要传递number类型参数，必须使用这个
} QGNetWorkRequestSerializer;

@interface QGNetWork : AFHTTPSessionManager

+ (instancetype)sharedManager;

/**
 Whether or not the network is currently reachable.
 */
- (BOOL)reachable;

/**
 GET 请求

 @param URLString 请求的链接
 @param parameters 请求的参数
 @param success 成功的回调
 @param failure 失败的回调
 */
- (void)GET:(NSString *)URLString parameters:(NSDictionary *)parameters success:(requestSuccessBlock)success failure:(requestFailureBlock)failure;

/**
 GET 请求 官方推荐使用

 @param URLString 请求的链接
 @param requestSerializer 请求参数编码的序列化器
 @param parameters 请求的参数
 @param businessSuccess 成功的回调
 @param failure 失败的回调
 */
- (void)GET:(NSString *)URLString requestSerializer:(QGNetWorkRequestSerializer)requestSerializer parameters:(NSDictionary *)parameters businessSuccess:(businessCodeRequestSuccessBlock)businessSuccess failure:(requestFailureBlock)failure;

/**
 GET 请求  有超时时间

 @param URLString 请求的链接
 @param timeoutInterval 超时时间
 @param parameters 请求的参数
 @param success 成功的回调
 @param failure 失败的回调
 */
- (void)GET:(NSString *)URLString timeoutInterval:(NSTimeInterval)timeoutInterval parameters:(NSDictionary *)parameters success:(requestSuccessBlock)success failure:(requestFailureBlock)failure;

/**
 POST 请求

 @param URLString 请求的链接
 @param parameters 请求的参数
 @param success 成功的回调
 @param failure 失败的回调
 */
- (void)POST:(NSString *)URLString parameters:(NSDictionary *)parameters success:(requestSuccessBlock)success failure:(requestFailureBlock)failure;

/**
 POST请求 官方推荐
 
 @param URLString 请求的链接
 @param requestSerializer 请求参数编码的序列化器
 @param parameters 请求的参数
 @param businessSuccess 成功的回调
 @param failure 失败的回调
 */
- (void)POST:(NSString *)URLString requestSerializer:(QGNetWorkRequestSerializer)requestSerializer parameters:(NSDictionary *)parameters businessSuccess:(businessCodeRequestSuccessBlock)businessSuccess failure:(requestFailureBlock)failure;

- (void)PUT:(NSString *)URLString parameters:(NSDictionary *)parameters success:(requestSuccessBlock)success failure:(requestFailureBlock)failure;

/**
 全局URL 最基本的请求

 @param urlString <#urlString description#>
 @param timeoutInterval <#timeoutInterval description#>
 @param opt <#opt description#>
 @param parameters <#parameters description#>
 @param success <#success description#>
 @param failure <#failure description#>
 */
- (void)sendRequestWithUrlString:(NSString *)urlString timeoutInterval:(NSTimeInterval)timeoutInterval opt:(NSString *)opt parameters:(NSDictionary *)parameters success:(requestSuccessBlock)success failure:(requestFailureBlock)failure;

- (BOOL)checkNetworkStatus;

// 获取网络连接类型
+ (NSString *)getNetworkType;
@end
