//
//  QGJYVerifyCodeManager.m
//  CreditWallet
//
//  Created by 张博 on 2019/3/6.
//  Copyright © 2019年 QuantGroup. All rights reserved.
//

#import "QGJYVerifyCodeManager.h"

#import <GT3Captcha/GT3Captcha.h>
#import "QGHUDManager.h"
#import "QGAppBusinessStateEvent.h"
@interface QGJYVerifyCodeManager ()<GT3CaptchaManagerDelegate,GT3CaptchaManagerViewDelegate>

@property (nonatomic, strong) GT3CaptchaManager *manager;

@property (nonatomic, strong) NSString * phoneNum;
@end


@implementation QGJYVerifyCodeManager

- (instancetype)init
{
    if (self = [super init]) {
        self.manager = [[GT3CaptchaManager alloc]initWithAPI1:@"" API2:@"" timeout:0];
        self.manager.delegate = self;
        [self.manager registerCaptcha:nil];
    }
    return self;
}


/// 自定义配置验证参数 开始二验
/// @param gt_public_key 在官网申请的captcha_id
/// @param gt_challenge 根据极验服务器sdk生成的challenge
/// @param gt_success_code 网站主服务器监测geetest服务的可用状态 0/1 不可用/可用
/// @param phoneNum 当前操作的手机号
- (void)configureGTest:(NSString *)gt_public_key
             challenge:(NSString *)gt_challenge
               success:(NSNumber *)gt_success_code
              phoneNum:(NSString *)phoneNum
{
    self.phoneNum = phoneNum;
    if (gt_public_key.length > 0 && gt_challenge.length > 0 && gt_success_code) {
        [self.manager configureGTest:gt_public_key challenge:gt_challenge success:gt_success_code withAPI2:nil];
        [self.manager startGTCaptchaWithAnimated:YES];
    }
}



#pragma mark - GT3CaptchaManagerDelegate

/**
 *  验证错误处理
 *
 *  @discussion 抛出内部错误, 比如GTWebView等错误
 *
 *  @param manager  验证管理器
 *  @param error    错误源
 */
- (void)gtCaptcha:(GT3CaptchaManager *)manager errorHandler:(GT3Error *)error
{
    //处理验证中返回的错误
    if (error.code == -999) {
        // 请求被意外中断, 一般由用户进行取消操作导致, 可忽略错误
    }
    else{
        //toast
        //尝试过多，请点击重试
        [QGHUDManager showHud:@"尝试过多，请点击重试"];
    }
    
    /*
    //处理验证中返回的错误
    if (error.code == -999) {
        // 请求被意外中断,一般由用户进行取消操作导致
    }
    else if (error.code == -10) {
        // 预判断时被封禁, 不会再进行图形验证
    }
    else if (error.code == -20) {
        // 尝试过多
    }
    else {
        // 网络问题或解析失败, 更多错误码参考开发文档
    }
     */
    
    QGAppBusinessStateEvent * event = [QGAppBusinessStateEvent abseEventWithPage:@"注册/登录" action:@"获取极验验证码" value:@"failed" code:error.error_code desc:error.gtDescription phone:self.phoneNum];
    [QGAnalyticsService analyticsTrackWithEvent:event];
}

/**
 *  @abstract 通知已经收到二次验证结果, 在此处理最终验证结果
 *
 *  @discussion
 *  二次验证的错误只在这里返回, `decisionHandler`需要处理
 *
 *  @param manager          验证管理器
 *  @param data             二次验证返回的数据
 *  @param response         二次验证的响应
 *  @param error            错误源
 *  @param decisionHandler  更新验证结果的视图
 */
- (void)gtCaptcha:(GT3CaptchaManager *)manager didReceiveSecondaryCaptchaData:(NSData *)data response:(NSURLResponse *)response error:(GT3Error *)error decisionHandler:(void (^)(GT3SecondaryCaptchaPolicy captchaPolicy))decisionHandler
{
    if (error) {
        QGAppBusinessStateEvent * event = [QGAppBusinessStateEvent abseEventWithPage:@"注册/登录" action:@"获取极验验证码" value:@"failed" code:error.error_code desc:error.gtDescription phone:self.phoneNum];
        [QGAnalyticsService analyticsTrackWithEvent:event];
    }
}

/**
 *  @abstract 通知接收到返回的验证交互结果
 *
 *  @discussion 此方法仅仅是前端返回的初步结果, 并非验证最终结果。
 *
 *  @param manager 验证管理器
 *  @param code    验证交互结果, 0失败/1成功
 *  @param result  二次验证数据
 *  @param message 附带消息
 */
- (void)gtCaptcha:(GT3CaptchaManager *)manager didReceiveCaptchaCode:(NSString *)code result:(NSDictionary *)result message:(NSString *)message
{
    if (code.integerValue == 1)
    {
        NSString * geetest_challenge = result[@"geetest_challenge"];
        NSString * geetest_seccode = result[@"geetest_seccode"];
        NSString * geetest_validate = result[@"geetest_validate"];
        
        if (self.successBlock) {
            self.successBlock(geetest_challenge, geetest_seccode, geetest_validate);
        }
        
        QGAppBusinessStateEvent * event = [QGAppBusinessStateEvent abseEventWithPage:@"注册/登录" action:@"获取极验验证码" value:@"success" code:code desc:message phone:self.phoneNum];
        [QGAnalyticsService analyticsTrackWithEvent:event];
    }
}

/**
 *  @abstract 用户主动关闭了验证码界面
 *
 *  @param manager 验证管理器
 */
- (void)gtCaptchaUserDidCloseGTView:(GT3CaptchaManager *)manager
{
    if (self.cancleBlock) {
        self.cancleBlock();
    }
}


/**
 * 不使用内部默认的API1请求逻辑
 */
- (BOOL)shouldUseDefaultRegisterAPI:(GT3CaptchaManager *)manager
{
    return NO;
}

/**
 * 不使用内部默认的API1请求逻辑
 */
- (BOOL)shouldUseDefaultSecondaryValidate:(GT3CaptchaManager *)manager {
    return NO;
}





@end
