//
//  QGJYVerifyCodeManager.h
//  CreditWallet
//  极验验证码管理工具
//  Created by 张博 on 2019/3/6.
//  Copyright © 2019年 QuantGroup. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

typedef void(^CodeManagerSuccessBlock)(NSString * geetest_challenge,NSString * geetest_seccode,NSString * geetest_validate);


@interface QGJYVerifyCodeManager : NSObject


/**
 用户取消回调
 */
@property (nonatomic, copy) dispatch_block_t cancleBlock;


/**
 用户成功回调
 */
@property (nonatomic, copy) CodeManagerSuccessBlock successBlock;


/// 自定义配置验证参数 开始二验
/// @param gt_public_key 在官网申请的captcha_id
/// @param gt_challenge 根据极验服务器sdk生成的challenge
/// @param gt_success_code 网站主服务器监测geetest服务的可用状态 0/1 不可用/可用
/// @param phoneNum 当前操作的手机号
- (void)configureGTest:(NSString *)gt_public_key
             challenge:(NSString *)gt_challenge
               success:(NSNumber *)gt_success_code
              phoneNum:(NSString *)phoneNum;

@end

NS_ASSUME_NONNULL_END
