//
//  QGHUDManager.h
//  VirtualPayment
//
//  Created by 张博 on 2019/5/8.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface QGHUDManager : NSObject

/**
 *  加载动画（传入str 则变成提示，2S后自动消失）
 */
+(void)showHud:(NSString * __nullable)str;

/**
 *  弹窗 N秒之后自动消失
 *
 *  @param str   弹窗文案
 *  @param delay 延时时间
 */
+(void)showHud:(NSString *)str afterDelay:(NSTimeInterval)delay;

/**
 根据错误信息做出提示

 @param responseObject 包含message层级的字典
 */
+(void)showHudWithError:(NSDictionary *)responseObject;

/**
 隐藏hud
 
 @param animated 是否需要动画
 */
+(void)hideHudAnimated:(BOOL)animated;

/**
 隐藏HUD带动画
 */
+(void)hideHud;

@end

NS_ASSUME_NONNULL_END
