//
//  QGDeviceTool.h
//  VirtualPayment
//
//  Created by 张博 on 2019/5/5.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import <CoreTelephony/CTCarrier.h>
#import <CoreTelephony/CTTelephonyNetworkInfo.h>
#import <SystemConfiguration/CaptiveNetwork.h>
NS_ASSUME_NONNULL_BEGIN

@interface QGDeviceTool : NSObject

/*!
 唯一标示符
 注意：如果程序被删除了，然后在安装，这个数值会改变。
 如果想要永久保证这个数字不变，需要使用Keychain来保存这个字符串
 */
+ (NSString *)QGUUID;

/**
 随机生成32 为长度的UUID
 */
+ (NSString *)create32UUIDString;

/*
 系统版本
 */
+ (CGFloat)systemVersion;

/**
 获取手机类型 mobileType
 @return iPhone 6s Plus
 */
+ (NSString *)getDeviceType;

/**
 获取手机类型 DevicePlatform
 @return iPhone7,2
 */
+ (NSString *)getDevicePlatformType;

/**
 获取手机系统+版本号  iPhone10.2.1
 @return iPhone10.2.1
 */
+ (NSString *)getMobileModel;

/**
 获取iPhone名称
 */
+ (NSString *)getiPhoneName;

/**
 获取手机屏幕大小
 */
+ (NSString *)getScreenSize;

/**
 获取CPU类型
 */
+ (NSString *)getHardParam;

/**
 获取CPU 核心数
 */
+ (int)getCountOfCores;

/**
 获取电池电量
 */
+ (CGFloat)getBatteryLevel;

/**
 当前系统名称
 */
+ (NSString *)getSystemName;

/**
 当前系统版本号
 */
+ (NSString *)getSystemVersion;

/**
 上次开机时间
 */
+ (NSString *)getSystemUptime;

/**
 判断cydia的URL scheme  是否越狱
 */
+ (BOOL)isJailBreak;


#pragma mark - 网络信息
/**
 获取当前设备IP
 */
+ (NSString *)getDeviceIPAdress;

/**
 获取运营商信息(IMSI)
 */
+ (CTCarrier *)getUserSubscriberCellularProvider;

/**
 获取手机运营商
 */
+ (NSString *)carrierName;


#pragma mark - 电池信息
/**
 获取电池电量
 */
+ (NSString *)getSystemBatteryLevel;

/**
 当前电池状态
 */
+ (NSString *)getSystemBatteryStat;

/**
 是否已经充满电
 */
+ (BOOL)isBatteryStateFullCharged;

/**
 是否插入耳机
 */
+ (BOOL)isHeadsetPluggedIn;

#pragma mark - WiFi
/**
 获取Wifi信息
 */
+ (id)fetchSSIDInfo;

/**
 获取WIFI名字
 */
+ (NSString *)getWifiSSID;

/**
 获取WIFI的MAC地址
 */
+ (NSString *)getWifiBSSID;

/**
WiFi是否打开
 */
+ (BOOL)isWiFiEnabled;


#pragma mark -存储信息
/**
 获取手机存储空间的大小
 */
+ (NSString *)getMaxspace;

/**
 获取手机可用空间的大小
 */
+ (NSString *)getFreeSpace;

/**
 获取磁盘已使用量
 */
+ (double)getUsedMemory;

#pragma mark -内存
/**
 获得设备总内存
 */
+ (long long)getTotalMemoryBytes;

/**
 获取内存已使用量
 */
+ (double)getMemory;


/**
 系统当前运行了多长时间

 @return 目标时长
 */
+ (NSTimeInterval)uptimeSinceLastBoot;

/**
 检测是否是模拟器
 */
+ (BOOL)checkSimulator;


#pragma mark - 获取CPU信息
+ (NSMutableDictionary *)getSystemCPUInfo;

#pragma mark - 设备标识符
+ (NSMutableDictionary *)getDeviceIdentifiers;

#pragma mark -存储信息
+ (NSMutableDictionary *)getDeviceStorageInfo;

#pragma mark - 设备系统信息
+ (NSMutableDictionary *)getDeviceSystemInfo;

#pragma mark - 网络信息
+ (NSMutableDictionary *)getUserNetworkInfo;

#pragma mark - 电池信息
+ (NSMutableDictionary *)getSystemBatteryInfo;

@end

NS_ASSUME_NONNULL_END
