//
//  QGCountDown.m
//  CreditWallet
//
//  Created by 张博 on 16/9/12.
//  Copyright © 2016年 QuantGroup. All rights reserved.
//

#import "QGCountDown.h"
#import <UIKit/UIKit.h>
@interface QGCountDown ()
@property (nonatomic, retain) dispatch_source_t timer;

@property (nonatomic, assign) BOOL isEnterBackground;
@end


@implementation QGCountDown


- (instancetype)init
{
    if (self = [super init]) {
        [self addNotification];
    }
    return self;
}


- (void)dealloc
{
    [self removeNotification];
}

/**
 添加通知
 */
- (void)addNotification
{
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(applicationWillResignActive:)
                                                 name:UIApplicationWillResignActiveNotification object:nil]; //监听是否触发home键挂起程序.
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(applicationDidBecomeActive:)
                                                 name:UIApplicationDidBecomeActiveNotification object:nil];
}

/**
 *  移除通知
 */
- (void)removeNotification
{
    [[NSNotificationCenter defaultCenter] removeObserver:self name:UIApplicationWillResignActiveNotification object:nil];
    [[NSNotificationCenter defaultCenter] removeObserver:self name:UIApplicationDidBecomeActiveNotification object:nil];
}


- (void)applicationWillResignActive:(NSNotification *)nofication
{
    self.isEnterBackground = YES;
}


- (void)applicationDidBecomeActive:(NSNotification *)nofication
{
    self.isEnterBackground = NO;
}


/**
 *  每秒回调一次
 */
-(void)countDownWithPER_SECBlock:(void (^)(void))PER_SECBlock
{
    if (_timer==nil) {
        __weak typeof(self) weakSelf = self;
        dispatch_queue_t queue = dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0);
        _timer = dispatch_source_create(DISPATCH_SOURCE_TYPE_TIMER, 0, 0,queue);
        dispatch_source_set_timer(_timer,dispatch_walltime(NULL, 0),1.0*NSEC_PER_SEC, 0); //每秒执行
        dispatch_source_set_event_handler(_timer, ^{
            dispatch_async(dispatch_get_main_queue(), ^{
                if (!weakSelf.isEnterBackground) {
                    PER_SECBlock();
                }
            });
        });
        dispatch_resume(_timer);
    }
}

/**
  每 sec 秒执行一次

 @param sec 秒数
 @param isImmediately 是否立即调用一次
 @param PER_SECBlock 事件回调
 */
-(void)countDownWithSEC:(float)sec isImmediatelySelector:(BOOL)isImmediately eventBlock:(void (^)(void))PER_SECBlock
{
    if (isImmediately && PER_SECBlock && !self.isEnterBackground) {
        PER_SECBlock();
    }
    
    if (_timer==nil) {
        __weak typeof(self) weakSelf = self;
        dispatch_queue_t queue = dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0);
        _timer = dispatch_source_create(DISPATCH_SOURCE_TYPE_TIMER, 0, 0,queue);
        dispatch_source_set_timer(_timer,dispatch_time(DISPATCH_TIME_NOW, sec * NSEC_PER_SEC),sec*NSEC_PER_SEC,0); //每秒执行
        dispatch_source_set_event_handler(_timer, ^{
            dispatch_async(dispatch_get_main_queue(), ^{
                if (!weakSelf.isEnterBackground) {
                    PER_SECBlock();
                }
            });
        });
        dispatch_resume(_timer);
    }
}


/**
 *  主动销毁定时器
 */
-(void)destoryTimer
{
    if (_timer) {
        dispatch_source_cancel(_timer);
        _timer = nil;
    }
}




@end
