//
//  QGDiskCache.m
//  CreditWallet
//
//  Created by 张博 on 16/11/17.
//  Copyright © 2016年 QuantGroup. All rights reserved.
//

#import "QGDiskCache.h"
static NSOperationQueue *dataQueue = nil;
@implementation QGDiskCache

+(NSOperationQueue*)sharedDataQueue
{
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        dataQueue = [[NSOperationQueue alloc] init];
        [dataQueue setMaxConcurrentOperationCount:10];
        [dataQueue setSuspended:NO];
    });
    return dataQueue;
}


+(NSString *)imageFilePath
{
    NSString *cachesPath = [NSSearchPathForDirectoriesInDomains(NSCachesDirectory, NSUserDomainMask, YES) lastObject];
    NSString *QGCachePath = [NSString stringWithFormat:@"%@/QGCache",cachesPath];
    if (![[NSFileManager defaultManager] fileExistsAtPath:QGCachePath]) {
        [[NSFileManager defaultManager] createDirectoryAtPath:QGCachePath withIntermediateDirectories:YES attributes:nil error:nil];
    }
    
    NSString * imageFilePath = [NSString stringWithFormat:@"%@/ImageFile",QGCachePath];
    if(![[NSFileManager defaultManager] fileExistsAtPath:imageFilePath])
    {
        [[NSFileManager defaultManager] createDirectoryAtPath:imageFilePath withIntermediateDirectories:YES attributes:nil error:nil];
    }
    return imageFilePath;
}

/**
 *  获取plist存储路径
 *
 *  @param fileName 文件名
 *
 *  @return 返回plist存储路径
 */
+ (NSString *)plistFilePath:(NSString *)fileName
{
    fileName = [fileName stringByAppendingString:@".plist"];
    NSArray *paths = NSSearchPathForDirectoriesInDomains(NSLibraryDirectory, NSUserDomainMask, YES);
    NSString *documentsDirectory = [paths objectAtIndex:0];
    return [documentsDirectory stringByAppendingPathComponent:fileName];
}


/**
 *  把字典保存到本地plist
 *
 *  @param dataDic  需要保存的字典
 *  @param fileName 文件名
 *
 *  @return 返回是否成功
 */
+(BOOL)saveToPlistFileWithData:(NSMutableDictionary *)dataDic fileName:(NSString *)fileName
{
    NSString * error = nil;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdeprecated-declarations"
    NSData * plistData = [NSPropertyListSerialization dataFromPropertyList:dataDic format:NSPropertyListXMLFormat_v1_0 errorDescription:&error];
#pragma clang diagnostic pop
    
    if(plistData)
    {
        return [plistData writeToFile:[self plistFilePath:fileName] atomically:YES];
    } else
    {
        return NO;
    }
}


/**
 *  将本地plist文件加载到内存中
 *
 *  @param fileName plist文件名
 *
 *  @return 返回字典
 */
+ (NSMutableDictionary *)loadDicFromPlistFile:(NSString *)fileName
{
//        NSError *error = nil;
    NSPropertyListFormat format;
    NSMutableDictionary *dict = nil;
    NSString *filePath = [self plistFilePath:fileName];
    if (![[NSFileManager defaultManager] fileExistsAtPath:filePath]) {
        filePath = [[NSBundle mainBundle] pathForResource:fileName ofType:@"plist"];
    }
    NSData *plistXML = [[NSFileManager defaultManager] contentsAtPath:filePath];
    
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdeprecated-declarations"
    dict = (NSMutableDictionary *)[NSPropertyListSerialization propertyListFromData:plistXML mutabilityOption:NSPropertyListMutableContainersAndLeaves format:&format errorDescription:nil];
#pragma clang diagnostic pop
    
//       dict = (NSMutableDictionary *)[NSPropertyListSerialization propertyListWithData:plistXML options:NSPropertyListMutableContainersAndLeaves format:&format error:&error];
    return dict;
}


/**
 *  删除本地的plist文件
 *
 *  @param fileName 文件名
 *
 *  @return 结果
 */
+(BOOL)removePlistWithFileName:(NSString *)fileName
{
    if (fileName.length == 0) {
        return NO;
    }
    NSError *error = nil;
    NSString *filePath = [self plistFilePath:fileName];
    if ([[NSFileManager defaultManager] fileExistsAtPath:filePath]) {
        [[NSFileManager defaultManager] removeItemAtPath:filePath error:&error];
    }
    if (error) {
        return NO;
    }
    return YES;
}

/**
 *  保存图片到本地路径
 *
 *  @param image      图片
 *  @param name       本地名称
 *  @param completion 完成回调
 */
+ (void)saveImage:(UIImage *)image withName:(NSString *)name completion:(void(^)())completion
{
    if (name.length == 0 || !image) {
        return;
    }
    NSString * imageFilePath = [self imageFilePath];
    NSString * filePath = [NSString stringWithFormat:@"%@/%@",imageFilePath,name];
    
    [[self sharedDataQueue] addOperationWithBlock:^{
        
        NSData * data = nil;
        int alphaInfo = CGImageGetAlphaInfo(image.CGImage);
        BOOL hasAlpha = !(alphaInfo == kCGImageAlphaNone ||
                          alphaInfo == kCGImageAlphaNoneSkipFirst ||
                          alphaInfo == kCGImageAlphaNoneSkipLast);
        BOOL imageIsPng = hasAlpha;
        
        if (imageIsPng) {
            data = UIImagePNGRepresentation(image);
        }
        else {
            data = UIImageJPEGRepresentation(image, (CGFloat)1.0);
        }
        
        BOOL result = [data writeToFile:filePath atomically:YES];
        
        NSLog(@"_______%d",result);
        if (completion) {
            [[NSOperationQueue mainQueue] addOperationWithBlock:^{
                completion();
            }];
        }
    }];
    
}

/**
 *  获取本地保存的图片
 *
 *  @param name 图片名字
 *
 *  @return 返回图片
 */
+ (void)imageWithName:(NSString *)name completion:(void(^)(UIImage * image))completion
{
    if (name.length == 0) {
        return;
    }
    NSString * imageFilePath = [self imageFilePath];
    NSString * filePath = [NSString stringWithFormat:@"%@/%@",imageFilePath,name];
    
    [[self sharedDataQueue] addOperationWithBlock:^{
        NSData * data = [NSData dataWithContentsOfFile:filePath];
        UIImage * image = [UIImage imageWithData:data];
        [[NSOperationQueue mainQueue] addOperationWithBlock:^{
            if (completion) {
                completion(image);
            }
        }];
    }];
}


/**
 *  获取本地保存图片 同步
 *
 *  @param name 图片名字
 *
 *  @return 图片
 */
+ (UIImage *)imageWithName:(NSString *)name
{
    if (name.length == 0) {
        return nil;
    }
    NSString * imageFilePath = [self imageFilePath];
    NSString * filePath = [NSString stringWithFormat:@"%@/%@",imageFilePath,name];
    NSData * data = [NSData dataWithContentsOfFile:filePath];
    UIImage * image = [UIImage imageWithData:data];
    return image;
}


/**
 *  移除本地保存的图片
 *
 *  @param name 图片名
 */
+ (void)removeImageWithName:(NSString *)name
{
    if (name.length == 0) {
        return;
    }
    
    NSString * imageFilePath = [self imageFilePath];
    NSString * filePath = [NSString stringWithFormat:@"%@/%@",imageFilePath,name];
    if ([[NSFileManager defaultManager] fileExistsAtPath:filePath]) {
        [[NSFileManager defaultManager] removeItemAtPath:filePath error:nil];
    }
    
}

/**
 *  删除本地所有保存的图片
 */
+ (void)removeAllImage
{
    NSString * imageFilePath = [self imageFilePath];
    [[self sharedDataQueue] addOperationWithBlock:^{
        NSFileManager *manager = [NSFileManager defaultManager];
        [manager removeItemAtPath:imageFilePath error:nil];
        [manager createDirectoryAtPath:imageFilePath withIntermediateDirectories:YES attributes:nil error:NULL];
    }];
}







@end
