//
//  QGDiskCache.h
//  CreditWallet
//
//  Created by 张博 on 16/11/17.
//  Copyright © 2016年 QuantGroup. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
@interface QGDiskCache : NSObject

/**
 *  保存图片到本地路径
 *
 *  @param image      图片
 *  @param name       本地名称
 *  @param completion 完成回调
 */
+ (void)saveImage:(UIImage *)image withName:(NSString *)name completion:(void(^)())completion;


/**
 *  获取本地保存的图片
 *
 *  @param name 图片名字
 */
+ (void)imageWithName:(NSString *)name completion:(void(^)(UIImage * image))completion;

/**
 *  获取本地保存图片 同步
 *
 *  @param name 图片名字
 *
 *  @return 图片
 */
+ (UIImage *)imageWithName:(NSString *)name;


/**
 *  移除本地保存的图片
 *
 *  @param name 图片名
 */
+ (void)removeImageWithName:(NSString *)name;

/**
 *  删除本地所有保存的图片
 */
+ (void)removeAllImage;



/**
 *  把字典保存到本地plist
 *
 *  @param dataDic  需要保存的字典
 *  @param fileName 文件名
 *
 *  @return 返回是否成功
 */
+(BOOL)saveToPlistFileWithData:(NSMutableDictionary *)dataDic fileName:(NSString *)fileName;

/**
 *  删除本地的plist文件
 *
 *  @param fileName 文件名
 *
 *  @return 结果
 */
+(BOOL)removePlistWithFileName:(NSString *)fileName;

/**
 *  将本地plist文件加载到内存中
 *
 *  @param fileName plist文件名
 *
 *  @return 返回字典
 */
+ (NSMutableDictionary *)loadDicFromPlistFile:(NSString *)fileName;






@end
