//
//  QGCacheManager.h
//  CreditWallet
//
//  Created by 张博 on 16/11/17.
//  Copyright © 2016年 QuantGroup. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
@interface QGCacheManager : NSObject



/**
 *  缓存管理类
 */
+ (instancetype)shareCacheManager;


/**
 *  保存用户相关配置到本地
 *
 *  @param value value
 *  @param key   key
 */
- (void)setUserConfigInfoValue:(id)value forKey:(NSString *)key;



/**
 *  批量保存用户相关配置到本地
 *
 *  @param infoDic 用户信息字典
 */
- (void)setUserConfigInfoWithDic:(NSDictionary *)infoDic;



/**
 *  获取用户配置
 *
 *  @param key key
 *
 *  @return value
 */
- (id)userConfigInfoValueForKey:(NSString *)key;



/**
 *  删除用户配置
 *
 *  @param keys keyArray
 */
- (void)removeUserConfigWithKeys:(NSArray *)keys;





/**
 *  保存APP配置到本地
 *  此配置与当前登录账户无关，不会因为登录/登出而被清除
 *  @param value value
 *  @param key   key
 */
- (void)setAPPConfigValue:(id)value forKey:(NSString *)key;



/**
 *  批量保存APP配置到本地
 *
 *  @param infoDic 用户信息字典
 */
- (void)setAPPConfigInfoWithDic:(NSDictionary *)infoDic;



/**
 *  获取APP配置
 *
 *  @param key key
 *
 *  @return value
 */
- (id)appConfigValueForKey:(NSString *)key;



/**
 *  删除用户配置
 *
 *  @param keys keyArray
 */
- (void)removeAppConfigWithKeys:(NSArray *)keys;


///**
// *  缓存到内存和本地
// *
// *  @param propertyKey   key
// *  @param propertyValye vale
// */
//- (void)cachePropertyWithKey:(NSString *)propertyKey value:(id)propertyValue;
//
//
///**
// *  从缓存中获取数据
// *
// *  @param propertyKey key
// */
//- (id)propertyWithKey:(NSString *)propertyKey;



/**
 *  保存图片到本地路径
 *
 *  @param image      图片
 *  @param name       本地名称
 *  @param completion 完成回调
 */
+ (void)saveImage:(UIImage *)image withName:(NSString *)name completion:(void(^)())completion;


/**
 *  获取本地保存的图片 异步
 *
 *  @param name 图片名字
 */
+ (void)imageWithName:(NSString *)name completion:(void(^)(UIImage * image))completion;


/**
 *  获取本地保存图片 同步
 *
 *  @param name 图片名字
 *
 *  @return 图片
 */
+ (UIImage *)imageWithName:(NSString *)name;


/**
 *  移除本地保存的图片
 *
 *  @param name 图片名
 */
+ (void)removeImageWithName:(NSString *)name;


/**
 *  删除本地所有保存的图片
 */
+ (void)removeAllImage;

@end
