//
//  UIView+Creat.m
//  VirtualPayment
//
//  Created by 张博 on 2019/5/5.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "UIView+Creat.h"

@implementation UIView (Creat)

///创建UIView
+ (UIView *)creatViewWithSuperView:(UIView *)superView backgroundColor:(UIColor *)backgroundColor
{
    UIView * view = [[UIView alloc]init];
    if (backgroundColor) {
        view.backgroundColor = backgroundColor;
    }
    if (superView) {
        [superView addSubview:view];
    }
    return view;
}

///创建imageView
+ (UIImageView *)creatImageViewWithSuperView:(UIView *)superView imageName:(NSString *)imageName
{
    UIImageView *imageView = [[UIImageView alloc] init];
    if (imageName.length > 0) {
        imageView.image = [UIImage imageNamed:imageName];
    }
    if (superView) {
        [superView addSubview:imageView];
    }
    return imageView;
}

///创建label
+ (UILabel *)creatLabelWithSuperView:(UIView *)superView title:(NSString *)title titleFontSize:(UIFont *)font textColor:(UIColor *)textColor alignment:(NSTextAlignment)textAlignment
{
    UILabel *label = [[UILabel alloc] init];
    label.text = title ? title : nil;
    label.font = font ? font : nil;
    label.textColor = textColor ? textColor : nil;
    label.textAlignment = textAlignment;
    if (superView) {
        [superView addSubview:label];
    }
    return label;
}


///创建textField
+ (UITextField *)creatTextFieldWithSuperView:(UIView *)superView placeholder:(NSString * )placeholder titleFontSize:(UIFont *)font textColor:(UIColor *)textColor tintColor:(UIColor *)tintColor clearButtonMode:(UITextFieldViewMode)clearButtonMode
{
    UITextField * textField = [[UITextField alloc] init];
    textField.textColor = textColor ? textColor : nil;
    textField.tintColor = tintColor ? tintColor : nil;
    textField.clearButtonMode = clearButtonMode;
    textField.placeholder = placeholder ? placeholder : nil;
    textField.font = font ? font : font;
    if (superView) {
        [superView addSubview:textField];
    }
    return textField;
}

///创建Button
+ (UIButton *)creatButtonWithSuperView:(UIView *)superView title:(NSString *)title titleFont:(UIFont *)font textColor:(UIColor *)textColor
{
    UIButton * button = [UIButton buttonWithType:UIButtonTypeCustom];
    button.titleLabel.font = font ? font : nil;
    if (title) {
        [button setTitle:title forState:UIControlStateNormal];
    }
    [button setTitleColor:textColor forState:UIControlStateNormal];
    if (superView) {
        [superView addSubview:button];
    }
    return button;
}

+(UIButton *)creatButtonWithBordercolor:(UIColor *)borderColor cornerRadius:(CGFloat)cornerRadius title:(NSString *)title titleFont:(UIFont *)font textColor:(UIColor *)textColor
{
    
    UIButton * button = [UIButton buttonWithType:UIButtonTypeCustom];
    button.titleLabel.font = font ? font : nil;
    if (title) {
        [button setTitle:title forState:UIControlStateNormal];
    }
    [button setTitleColor:textColor forState:UIControlStateNormal];
    
    button.layer.borderColor = borderColor.CGColor;
    button.layer.borderWidth = 0.5;
    button.layer.cornerRadius = cornerRadius;
    

    return button;
    
}

@end
