//
//  UIView+Creat.h
//  VirtualPayment
//
//  Created by 张博 on 2019/5/5.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <objc/message.h>


@interface UIView (Creat)

/**
 创建UIView

 @param superView 父视图
 @param backgroundColor 背景色
 @return view实例
 */
+ (UIView *)creatViewWithSuperView:(UIView *)superView backgroundColor:(UIColor *)backgroundColor;

/**
 创建imageView

 @param superView 父视图
 @param imageName 图片名字
 @return imageView
 */
+ (UIImageView *)creatImageViewWithSuperView:(UIView *)superView imageName:(NSString *)imageName;

/**
 创建label

 @param superView 父视图
 @param title 文案
 @param font 字体大小
 @param textColor 字体颜色
 @param textAlignment 居左中右
 @return label实例
 */
+ (UILabel *)creatLabelWithSuperView:(UIView *)superView title:(NSString *)title titleFontSize:(UIFont *)font textColor:(UIColor *)textColor alignment:(NSTextAlignment)textAlignment;

/**
 创建输入框
 
 @param superView 父视图
 @param placeholder 提示文案
 @param font 字体大小
 @param textColor 字体颜色
 @param tintColor tintColor
 @param clearButtonMode clearButtonMode
 @return 输入框实例
 */
+ (UITextField *)creatTextFieldWithSuperView:(UIView *)superView placeholder:(NSString * )placeholder titleFontSize:(UIFont *)font textColor:(UIColor *)textColor tintColor:(UIColor *)tintColor clearButtonMode:(UITextFieldViewMode)clearButtonMode;

/**
  创建按钮
 
 @param superView 父视图
 @param font 字体大小
 @param textColor 字体颜色
 @return 按钮实例
 */
+ (UIButton *)creatButtonWithSuperView:(UIView *)superView title:(NSString *)title titleFont:(UIFont *)font textColor:(UIColor *)textColor;


/**
 创建带边框的按钮

 @param borderColor 边框颜色
 @param cornerRadius 圆角大小
 @param title 按钮标题
 @param font 字体大小
 @param textColor 字体颜色
 @return 按钮实例
 */
+(UIButton *)creatButtonWithBordercolor:(UIColor *)borderColor cornerRadius:(CGFloat)cornerRadius title:(NSString *)title titleFont:(UIFont *)font textColor:(UIColor *)textColor;

@end


